/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.IgnoreNullIterableTypeAdapterFactory;

public class CloudStackParserModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(CloudStackDateAdapter.class);
        this.bind(IgnoreNullIterableTypeAdapterFactory.class).to(CommaDelimitedOKIgnoreNullIterableTypeAdapterFactory.class);
    }

    public static class CommaDelimitedOKIgnoreNullIterableTypeAdapterFactory
    extends IgnoreNullIterableTypeAdapterFactory {
        @Override
        protected <E> TypeAdapter<Iterable<E>> newIterableAdapter(final TypeAdapter<E> elementAdapter) {
            return new TypeAdapter<Iterable<E>>(){

                @Override
                public void write(JsonWriter out, Iterable<E> value) throws IOException {
                    out.beginArray();
                    for (Object element : value) {
                        elementAdapter.write(out, element);
                    }
                    out.endArray();
                }

                @Override
                public Iterable<E> read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.STRING) {
                        String val = Strings.emptyToNull(in.nextString());
                        return val != null ? Splitter.on(',').split(val) : ImmutableSet.of();
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    in.beginArray();
                    while (in.hasNext()) {
                        Object element = elementAdapter.read(in);
                        if (element == null) continue;
                        builder.add(element);
                    }
                    in.endArray();
                    return builder.build();
                }
            }.nullSafe();
        }
    }

    public static class CloudStackDateAdapter
    extends GsonModule.Iso8601DateAdapter {
        @Inject
        private CloudStackDateAdapter(DateService dateService) {
            super(dateService);
        }

        @Override
        public Date read(JsonReader reader) throws IOException {
            return this.parseDate(reader.nextString().replaceAll("'T'", "T"));
        }
    }
}

