/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.InetAddresses2;
import org.jclouds.util.Throwables2;

@Singleton
public class VirtualMachineToNodeMetadata
implements Function<VirtualMachine, NodeMetadata> {
    public static final Map<VirtualMachine.State, NodeMetadata.Status> vmStateToNodeStatus = ImmutableMap.builder().put(VirtualMachine.State.STARTING, NodeMetadata.Status.PENDING).put(VirtualMachine.State.RUNNING, NodeMetadata.Status.RUNNING).put(VirtualMachine.State.STOPPING, NodeMetadata.Status.PENDING).put(VirtualMachine.State.STOPPED, NodeMetadata.Status.SUSPENDED).put(VirtualMachine.State.DESTROYED, NodeMetadata.Status.TERMINATED).put(VirtualMachine.State.EXPUNGING, NodeMetadata.Status.TERMINATED).put(VirtualMachine.State.MIGRATING, NodeMetadata.Status.PENDING).put(VirtualMachine.State.ERROR, NodeMetadata.Status.ERROR).put(VirtualMachine.State.UNKNOWN, NodeMetadata.Status.UNRECOGNIZED).put(VirtualMachine.State.SHUTDOWNED, NodeMetadata.Status.PENDING).put(VirtualMachine.State.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    private final FindLocationForVirtualMachine findLocationForVirtualMachine;
    private final FindImageForVirtualMachine findImageForVirtualMachine;
    private final LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    VirtualMachineToNodeMetadata(FindLocationForVirtualMachine findLocationForVirtualMachine, FindImageForVirtualMachine findImageForVirtualMachine, LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.findLocationForVirtualMachine = Preconditions.checkNotNull(findLocationForVirtualMachine, "findLocationForVirtualMachine");
        this.findImageForVirtualMachine = Preconditions.checkNotNull(findImageForVirtualMachine, "findImageForVirtualMachine");
        this.getIPForwardingRulesByVirtualMachine = Preconditions.checkNotNull(getIPForwardingRulesByVirtualMachine, "getIPForwardingRulesByVirtualMachine");
    }

    @Override
    public NodeMetadata apply(VirtualMachine from) {
        HashSet<String> privateAddresses;
        HashSet<String> publicAddresses;
        NodeMetadataBuilder builder;
        block9: {
            builder = new NodeMetadataBuilder();
            builder.ids(from.getId() + "");
            builder.name(from.getName());
            builder.hostname(from.getDisplayName());
            builder.location((Location)this.findLocationForVirtualMachine.apply(from));
            builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getDisplayName()));
            Image image = (Image)this.findImageForVirtualMachine.apply(from);
            if (image != null) {
                builder.imageId(image.getId());
                builder.operatingSystem(image.getOperatingSystem());
            }
            builder.hardware(new HardwareBuilder().ids(from.getServiceOfferingId() + "").name(from.getServiceOfferingName() + "").processors(ImmutableList.of(new Processor(from.getCpuCount(), from.getCpuSpeed()))).ram((int)from.getMemory()).hypervisor(from.getHypervisor()).build());
            builder.status(vmStateToNodeStatus.get((Object)from.getState()));
            publicAddresses = Sets.newHashSet();
            privateAddresses = Sets.newHashSet();
            if (from.getIPAddress() != null) {
                boolean isPrivate = InetAddresses2.isPrivateIPAddress(from.getIPAddress());
                if (isPrivate) {
                    privateAddresses.add(from.getIPAddress());
                } else {
                    publicAddresses.add(from.getIPAddress());
                }
            }
            if (from.getPublicIP() != null) {
                publicAddresses.add(from.getPublicIP());
            }
            for (NIC nic : from.getNICs()) {
                if (nic.getIPAddress() == null) continue;
                if (InetAddresses2.isPrivateIPAddress(nic.getIPAddress())) {
                    privateAddresses.add(nic.getIPAddress());
                    continue;
                }
                publicAddresses.add(nic.getIPAddress());
            }
            try {
                Iterables.addAll(publicAddresses, Iterables.transform(Iterables.filter((Iterable)this.getIPForwardingRulesByVirtualMachine.getUnchecked(from.getId()), new Predicate<IPForwardingRule>(){

                    @Override
                    public boolean apply(IPForwardingRule rule) {
                        return !"Deleting".equals(rule.getState());
                    }
                }), new Function<IPForwardingRule, String>(){

                    @Override
                    public String apply(IPForwardingRule rule) {
                        return rule.getIPAddress();
                    }
                }));
            }
            catch (UncheckedExecutionException e) {
                if (Throwables2.getFirstThrowableOfType(e, ResourceNotFoundException.class) != null) break block9;
                Throwables.propagateIfPossible(e.getCause());
                throw e;
            }
        }
        return builder.privateAddresses(privateAddresses).publicAddresses(publicAddresses).build();
    }

    @Singleton
    public static class FindImageForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Image> {
        @Inject
        public FindImageForVirtualMachine(@Memoized Supplier<Set<? extends Image>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualMachine from, Image input) {
            return input.getProviderId().equals(from.getTemplateId() + "") && (input.getLocation() == null || input.getId().equals(from.getZoneId() + ""));
        }
    }

    @Singleton
    public static class FindHardwareForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Hardware> {
        @Inject
        public FindHardwareForVirtualMachine(@Memoized Supplier<Set<? extends Hardware>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualMachine from, Hardware input) {
            return input.getProviderId().equals(from.getServiceOfferingId());
        }
    }

    @Singleton
    public static class FindLocationForVirtualMachine
    extends FindResourceInSet<VirtualMachine, Location> {
        @Inject
        public FindLocationForVirtualMachine(@Memoized Supplier<Set<? extends Location>> location) {
            super(location);
        }

        @Override
        public boolean matches(VirtualMachine from, Location input) {
            return input.getId().equals(from.getZoneId());
        }
    }
}

