/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.StaticIPInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet;
import org.jclouds.http.HttpResponse;

@Singleton
public class KeyValuesDelimitedByBlankLinesToStaticIPInfo
implements Function<HttpResponse, StaticIPInfo> {
    private final ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet setParser;

    @Inject
    public KeyValuesDelimitedByBlankLinesToStaticIPInfo(ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet setParser) {
        this.setParser = setParser;
    }

    @Override
    public StaticIPInfo apply(HttpResponse response) {
        Set<StaticIPInfo> drives = this.setParser.apply(response);
        if (drives.size() == 0) {
            return null;
        }
        return Iterables.get(drives, 0);
    }
}

