/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.Drive;

@Singleton
public class BaseDriveToMap
implements Function<Drive, Map<String, String>> {
    @Override
    public Map<String, String> apply(Drive from) {
        Preconditions.checkNotNull(from, "drive");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("name", from.getName());
        builder.put("size", from.getSize() + "");
        if (from.getClaimType() != ClaimType.EXCLUSIVE) {
            builder.put("claim:type", from.getClaimType().toString());
        }
        if (from.getTags().size() != 0) {
            builder.put("tags", Joiner.on(' ').join(from.getTags()));
        }
        if (from.getReaders().size() != 0) {
            builder.put("readers", Joiner.on(' ').join(from.getReaders()));
        }
        if (from.getUse().size() != 0) {
            builder.put("use", Joiner.on(' ').join(from.getUse()));
        }
        return builder.build();
    }
}

