/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveMetrics;
import org.jclouds.cloudsigma.domain.DriveStatus;
import org.jclouds.cloudsigma.domain.DriveType;
import org.jclouds.javax.annotation.Nullable;

public class DriveInfo
extends Drive {
    protected final DriveStatus status;
    protected final String user;
    protected final Set<String> claimed;
    @Nullable
    protected final String encryptionCipher;
    @Nullable
    protected final String imaging;
    protected final DriveMetrics metrics;
    private final Boolean autoexpanding;
    private final Integer bits;
    private final String description;
    private final ImmutableSet<String> driveType;
    private final String encryptionKey;
    private final Boolean free;
    private final String installNotes;
    private final String os;
    private final DriveType type;
    private final URI url;

    public DriveInfo(String uuid, String name, long size, ClaimType claimType, Iterable<String> tags, Iterable<String> readers, Iterable<String> use, DriveStatus status, String user, Set<String> claimed, String encryptionCipher, String imaging, DriveMetrics metrics, Boolean autoexpanding, Integer bits, String description, Iterable<String> driveType, String encryptionKey, Boolean free, String installNotes, String os, DriveType type, URI url) {
        super(uuid, name, size, claimType, tags, readers, use);
        this.status = status;
        this.user = user;
        this.claimed = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(claimed, "claimed"));
        this.encryptionCipher = encryptionCipher;
        this.imaging = imaging;
        this.metrics = Preconditions.checkNotNull(metrics, "metrics");
        this.autoexpanding = autoexpanding;
        this.bits = bits;
        this.description = description;
        this.driveType = ImmutableSet.copyOf(driveType);
        this.encryptionKey = encryptionKey;
        this.free = free;
        this.installNotes = installNotes;
        this.os = os;
        this.type = type;
        this.url = url;
    }

    public DriveStatus getStatus() {
        return this.status;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getClaimed() {
        return this.claimed;
    }

    @Nullable
    public String getEncryptionCipher() {
        return this.encryptionCipher;
    }

    public String getImaging() {
        return this.imaging;
    }

    public DriveMetrics getMetrics() {
        return this.metrics;
    }

    public Boolean getAutoexpanding() {
        return this.autoexpanding;
    }

    public Integer getBits() {
        return this.bits;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getDriveType() {
        return this.driveType;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public Boolean getFree() {
        return this.free;
    }

    public String getInstallNotes() {
        return this.installNotes;
    }

    public String getOs() {
        return this.os;
    }

    public DriveType getType() {
        return this.type;
    }

    public URI getUrl() {
        return this.url;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoexpanding == null ? 0 : this.autoexpanding.hashCode());
        result = 31 * result + (this.bits == null ? 0 : this.bits.hashCode());
        result = 31 * result + (this.claimed == null ? 0 : ((Object)this.claimed).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.driveType == null ? 0 : this.driveType.hashCode());
        result = 31 * result + (this.encryptionCipher == null ? 0 : this.encryptionCipher.hashCode());
        result = 31 * result + (this.encryptionKey == null ? 0 : this.encryptionKey.hashCode());
        result = 31 * result + (this.free == null ? 0 : this.free.hashCode());
        result = 31 * result + (this.imaging == null ? 0 : this.imaging.hashCode());
        result = 31 * result + (this.installNotes == null ? 0 : this.installNotes.hashCode());
        result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriveInfo other = (DriveInfo)obj;
        if (this.autoexpanding == null ? other.autoexpanding != null : !this.autoexpanding.equals(other.autoexpanding)) {
            return false;
        }
        if (this.bits == null ? other.bits != null : !this.bits.equals(other.bits)) {
            return false;
        }
        if (this.claimed == null ? other.claimed != null : !((Object)this.claimed).equals(other.claimed)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.driveType == null ? other.driveType != null : !this.driveType.equals(other.driveType)) {
            return false;
        }
        if (this.encryptionCipher == null ? other.encryptionCipher != null : !this.encryptionCipher.equals(other.encryptionCipher)) {
            return false;
        }
        if (this.encryptionKey == null ? other.encryptionKey != null : !this.encryptionKey.equals(other.encryptionKey)) {
            return false;
        }
        if (this.free == null ? other.free != null : !this.free.equals(other.free)) {
            return false;
        }
        if (this.imaging == null ? other.imaging != null : !this.imaging.equals(other.imaging)) {
            return false;
        }
        if (this.installNotes == null ? other.installNotes != null : !this.installNotes.equals(other.installNotes)) {
            return false;
        }
        if (this.metrics == null ? other.metrics != null : !this.metrics.equals(other.metrics)) {
            return false;
        }
        if (this.os == null ? other.os != null : !this.os.equals(other.os)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @Override
    public String toString() {
        return "[size=" + this.size + ", claimType=" + (Object)((Object)this.claimType) + ", tags=" + this.tags + ", readers=" + this.readers + ", uuid=" + this.uuid + ", name=" + this.name + ", use=" + this.use + ", status=" + (Object)((Object)this.status) + ", user=" + this.user + ", claimed=" + this.claimed + ", encryptionCipher=" + this.encryptionCipher + ", imaging=" + this.imaging + ", metrics=" + this.metrics + "]";
    }

    public static class Builder
    extends Drive.Builder {
        protected DriveStatus status;
        protected String user;
        protected Set<String> claimed = ImmutableSet.of();
        @Nullable
        protected String encryptionCipher;
        @Nullable
        protected String imaging;
        protected DriveMetrics metrics;
        private Boolean autoexpanding;
        private Integer bits;
        private String description;
        private Set<String> driveType = ImmutableSet.of();
        private String encryptionKey;
        private Boolean free;
        private String installNotes;
        private String os;
        private DriveType type;
        private URI url;

        public Builder status(DriveStatus status) {
            this.status = status;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder claimed(Iterable<String> claimed) {
            this.claimed = ImmutableSet.copyOf(Preconditions.checkNotNull(claimed, "claimed"));
            return this;
        }

        public Builder imaging(String imaging) {
            this.imaging = imaging;
            return this;
        }

        public Builder metrics(DriveMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder encryptionCipher(String encryptionCipher) {
            this.encryptionCipher = encryptionCipher;
            return this;
        }

        public Builder autoexpanding(Boolean autoexpanding) {
            this.autoexpanding = autoexpanding;
            return this;
        }

        public Builder bits(Integer bits) {
            this.bits = bits;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder driveType(Iterable<String> driveType) {
            this.driveType = ImmutableSet.copyOf(Preconditions.checkNotNull(driveType, "driveType"));
            return this;
        }

        public Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder free(Boolean free) {
            this.free = free;
            return this;
        }

        public Builder installNotes(String installNotes) {
            this.installNotes = installNotes;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public Builder type(DriveType type) {
            this.type = type;
            return this;
        }

        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        @Override
        public Builder claimType(ClaimType claimType) {
            return (Builder)Builder.class.cast(super.claimType(claimType));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags(tags));
        }

        @Override
        public Builder readers(Iterable<String> readers) {
            return (Builder)Builder.class.cast(super.readers(readers));
        }

        @Override
        public Builder size(long size) {
            return (Builder)Builder.class.cast(super.size(size));
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder use(Iterable<String> use) {
            return (Builder)Builder.class.cast(super.use((Iterable)use));
        }

        public static Builder fromDriveInfo(DriveInfo in) {
            return ((Builder)((Builder)new Builder().uuid(in.getUuid()).name(in.getName()).size(in.getSize()).claimType(in.getClaimType()).readers(in.getReaders())).use(in.getUse())).status(in.getStatus()).user(in.getUser()).claimed(in.getClaimed()).encryptionCipher(in.getEncryptionCipher()).imaging(in.getImaging()).metrics(in.getMetrics()).autoexpanding(in.getAutoexpanding()).bits(in.getBits()).description(in.getDescription()).encryptionKey(in.getEncryptionKey()).free(in.getFree()).installNotes(in.getInstallNotes()).type(in.getType()).url(in.getUrl());
        }

        @Override
        public DriveInfo build() {
            return new DriveInfo(this.uuid, this.name, this.size, this.claimType, this.tags, this.readers, this.use, this.status, this.user, this.claimed, this.encryptionCipher, this.imaging, this.metrics, this.autoexpanding, this.bits, this.description, this.driveType, this.encryptionKey, this.free, this.installNotes, this.os, this.type, this.url);
        }
    }
}

