/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.PredicateWithResult;

public final class GetImageWhenStatusActivePredicateWithResult
implements PredicateWithResult<Integer, org.jclouds.compute.domain.Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudServersClient client;
    private final Function<Image, org.jclouds.compute.domain.Image> cloudserversImageToImage;
    private Image result;
    private RuntimeException lastFailure;

    @Inject
    public GetImageWhenStatusActivePredicateWithResult(CloudServersClient client, Function<Image, org.jclouds.compute.domain.Image> cloudserversImageToImage) {
        this.client = client;
        this.cloudserversImageToImage = cloudserversImageToImage;
    }

    @Override
    public boolean apply(Integer input) {
        this.result = Preconditions.checkNotNull(this.findImage(input));
        switch (this.result.getStatus()) {
            case ACTIVE: {
                this.logger.info("<< Image %s is available for use. %s", input, this.result);
                return true;
            }
            case QUEUED: 
            case PREPARING: 
            case SAVING: {
                this.logger.debug("<< Image %s is not available yet. %s", input, this.result);
                return false;
            }
        }
        this.lastFailure = new IllegalStateException("Image " + input + " was not created. " + this.result);
        throw this.lastFailure;
    }

    @Override
    public org.jclouds.compute.domain.Image getResult() {
        return this.cloudserversImageToImage.apply(this.result);
    }

    @Override
    public Throwable getLastFailure() {
        return this.lastFailure;
    }

    private Image findImage(final int id) {
        return Iterables.tryFind(this.client.listImages(new ListOptions().withDetails()), new Predicate<Image>(){

            @Override
            public boolean apply(Image input) {
                return input.getId() == id;
            }
        }).orNull();
    }
}

