/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseContainerCDNMetadataFromHeaders
implements Function<HttpResponse, ContainerCDNMetadata>,
InvocationContext<ParseContainerCDNMetadataFromHeaders> {
    private HttpRequest request;

    @Override
    public ContainerCDNMetadata apply(HttpResponse from) {
        String cdnEnabled = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-CDN-Enabled"), "X-CDN-Enabled");
        String cdnLogRetention = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Log-Retention"), "X-Log-Retention");
        String cdnTTL = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-TTL"), "X-TTL");
        String cdnUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-CDN-URI"), "X-CDN-URI");
        String cdnSslUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Ssl-Uri"), "X-Cdn-Ssl-Uri");
        String cdnStreamingUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Streaming-Uri"), "X-Cdn-Streaming-Uri");
        if (cdnUri == null) {
            return null;
        }
        return new ContainerCDNMetadata(this.request.getEndpoint().getPath(), Boolean.parseBoolean(cdnEnabled), Boolean.parseBoolean(cdnLogRetention), Long.parseLong(cdnTTL), URI.create(cdnUri), URI.create(cdnSslUri), URI.create(cdnStreamingUri));
    }

    @Override
    public ParseContainerCDNMetadataFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

