/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.List;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.domain.YamlNode;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

@Singleton
public class NodesFromYamlStream
implements Function<InputStream, LoadingCache<String, Node>> {
    @Override
    public LoadingCache<String, Node> apply(InputStream source) {
        Constructor constructor = new Constructor(Config.class);
        TypeDescription nodeDesc = new TypeDescription(YamlNode.class);
        nodeDesc.putListPropertyType("tags", String.class);
        constructor.addTypeDescription(nodeDesc);
        TypeDescription configDesc = new TypeDescription(Config.class);
        configDesc.putListPropertyType("nodes", YamlNode.class);
        constructor.addTypeDescription(configDesc);
        Yaml yaml = new Yaml(new Loader(constructor));
        Config config = (Config)yaml.load(source);
        Preconditions.checkState(config != null, "missing config: class");
        Preconditions.checkState(config.nodes != null, "missing nodes: collection");
        ImmutableMap<String, Node> backingMap = Maps.uniqueIndex(Iterables.transform(config.nodes, YamlNode.toNode), new Function<Node, String>(){

            @Override
            public String apply(Node node) {
                return node.getId();
            }
        });
        LoadingCache<String, Node> cache = CacheBuilder.newBuilder().build(CacheLoader.from(Functions.forMap(backingMap)));
        for (String node : backingMap.keySet()) {
            cache.getUnchecked(node);
        }
        return cache;
    }

    public static class Config {
        public List<YamlNode> nodes;
    }
}

