/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.strategy;

import com.google.common.base.Throwables;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.functions.ObjectMD5;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.ListBlobsInContainer;

@Singleton
public class FindMD5InBlobProperties
implements ContainsValueInListStrategy {
    protected final ObjectMD5 objectMD5;
    protected final ListBlobsInContainer getAllBlobMetadata;
    private final AzureBlobClient client;

    @Inject
    private FindMD5InBlobProperties(ObjectMD5 objectMD5, ListBlobsInContainer getAllBlobMetadata, AzureBlobClient client) {
        this.objectMD5 = objectMD5;
        this.getAllBlobMetadata = getAllBlobMetadata;
        this.client = client;
    }

    @Override
    public boolean execute(String containerName, Object value, ListContainerOptions options) {
        try {
            byte[] toSearch = this.objectMD5.apply(value);
            for (BlobMetadata blobMetadata : this.getAllBlobMetadata.execute(containerName, options)) {
                BlobProperties properties = this.client.getBlobProperties(containerName, blobMetadata.getName());
                if (!Arrays.equals(toSearch, properties.getContentMetadata().getContentMD5())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e, BlobRuntimeException.class);
            throw new BlobRuntimeException(String.format("Error searching for ETAG of value: [%2$s] in container:%1$s", containerName, value), e);
        }
    }
}

