/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.sqs;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.aws.domain.Region;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;
import org.jclouds.sqs.SQSApiMetadata;

public class AWSSQSProviderMetadata
extends BaseProviderMetadata {
    private static final long serialVersionUID = 7750012233546655021L;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)Builder.class.cast(AWSSQSProviderMetadata.builder().fromProviderMetadata(this));
    }

    public AWSSQSProviderMetadata() {
        super(AWSSQSProviderMetadata.builder());
    }

    public AWSSQSProviderMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Region.regionProperties());
        properties.setProperty("jclouds.region.us-east-1.endpoint", "https://sqs.us-east-1.amazonaws.com");
        properties.setProperty("jclouds.region.us-west-1.endpoint", "https://sqs.us-west-1.amazonaws.com");
        properties.setProperty("jclouds.region.us-west-2.endpoint", "https://sqs.us-west-2.amazonaws.com");
        properties.setProperty("jclouds.region.sa-east-1.endpoint", "https://sqs.sa-east-1.amazonaws.com");
        properties.setProperty("jclouds.region.eu-west-1.endpoint", "https://sqs.eu-west-1.amazonaws.com");
        properties.setProperty("jclouds.region.ap-southeast-1.endpoint", "https://sqs.ap-southeast-1.amazonaws.com");
        properties.setProperty("jclouds.region.ap-southeast-2.endpoint", "https://sqs.ap-southeast-2.amazonaws.com");
        properties.setProperty("jclouds.region.ap-northeast-1.endpoint", "https://sqs.ap-northeast-1.amazonaws.com");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("aws-sqs").name("Amazon Simple Queue Service").endpoint("https://sqs.us-east-1.amazonaws.com").homepage(URI.create("http://aws.amazon.com/sqs")).console(URI.create("https://console.aws.amazon.com/ec2/home")).linkedServices("aws-ec2", "aws-rds", "aws-sqs", "aws-elb", "aws-iam", "aws-cloudwatch", "aws-s3", "aws-simpledb").iso3166Codes("US-VA", "US-CA", "BR-SP", "US-OR", "IE", "SG", "AU-NSW", "JP-13").apiMetadata(new SQSApiMetadata()).defaultProperties(AWSSQSProviderMetadata.defaultProperties());
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

