/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.functions;

import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ETagFromHttpResponseViaRegex
implements Function<HttpResponse, String> {
    private static Pattern pattern = Pattern.compile("<ETag>([\\S&&[^<]]+)</ETag>");
    private static Pattern quotPattern = Pattern.compile("(&quot;)");
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    ETagFromHttpResponseViaRegex(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    @Override
    public String apply(HttpResponse response) {
        Matcher matcher;
        String value = null;
        String content = this.returnStringIf200.apply(response);
        if (content != null && (matcher = pattern.matcher(content)).find()) {
            value = matcher.group(1);
            Matcher quotMatcher = quotPattern.matcher(value);
            StringBuffer quotBuffer = new StringBuffer();
            boolean foundUnescapedQuote = false;
            while (quotMatcher.find()) {
                quotMatcher.appendReplacement(quotBuffer, "\"");
                foundUnescapedQuote = true;
            }
            if (foundUnescapedQuote) {
                quotMatcher.appendTail(quotBuffer);
                value = quotBuffer.toString();
            }
        }
        return value;
    }
}

