/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobStoreListOptionsToListOptions;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.blobstore.functions.DirectoryEntryListToResourceMetadataList;
import org.jclouds.atmos.blobstore.functions.ObjectToBlob;
import org.jclouds.atmos.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.concurrent.Futures;
import org.jclouds.crypto.Crypto;
import org.jclouds.domain.Location;

@Singleton
public class AtmosAsyncBlobStore
extends BaseAsyncBlobStore {
    private final AtmosAsyncClient async;
    private final AtmosClient sync;
    private final ObjectToBlob object2Blob;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToObject blob2Object;
    private final BlobStoreListOptionsToListOptions container2ContainerListOptions;
    private final DirectoryEntryListToResourceMetadataList container2ResourceList;
    private final Crypto crypto;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final LoadingCache<String, Boolean> isPublic;

    @Inject
    AtmosAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, AtmosAsyncClient async, AtmosClient sync, ObjectToBlob object2Blob, ObjectToBlobMetadata object2BlobMd, BlobToObject blob2Object, BlobStoreListOptionsToListOptions container2ContainerListOptions, DirectoryEntryListToResourceMetadataList container2ResourceList, Crypto crypto, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, LoadingCache<String, Boolean> isPublic) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.async = Preconditions.checkNotNull(async, "async");
        this.container2ContainerListOptions = Preconditions.checkNotNull(container2ContainerListOptions, "container2ContainerListOptions");
        this.container2ResourceList = Preconditions.checkNotNull(container2ResourceList, "container2ResourceList");
        this.object2Blob = Preconditions.checkNotNull(object2Blob, "object2Blob");
        this.blob2Object = Preconditions.checkNotNull(blob2Object, "blob2Object");
        this.object2BlobMd = Preconditions.checkNotNull(object2BlobMd, "object2BlobMd");
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.fetchBlobMetadataProvider = Preconditions.checkNotNull(fetchBlobMetadataProvider, "fetchBlobMetadataProvider");
        this.isPublic = Preconditions.checkNotNull(isPublic, "isPublic");
    }

    @Override
    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        return Futures.compose(this.async.headFile(container + "/" + key), new Function<AtmosObject, BlobMetadata>(){

            @Override
            public BlobMetadata apply(AtmosObject from) {
                return AtmosAsyncBlobStore.this.object2BlobMd.apply(from);
            }
        }, this.service);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container) {
        return Futures.compose(this.async.createDirectory(container, new PutOptions[0]), new Function<URI, Boolean>(){

            @Override
            public Boolean apply(URI from) {
                return true;
            }
        }, this.service);
    }

    @Override
    public ListenableFuture<Void> createDirectory(String container, String directory) {
        return Futures.compose(this.async.createDirectory(container + "/" + directory, new PutOptions[0]), new Function<URI, Void>(){

            @Override
            public Void apply(URI from) {
                return null;
            }
        }, this.service);
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deletePath(container + "/");
        return !this.sync.pathExists(container + "/");
    }

    @Override
    public ListenableFuture<Boolean> containerExists(String container) {
        return this.async.pathExists(container + "/");
    }

    @Override
    public ListenableFuture<Boolean> directoryExists(String container, String directory) {
        return this.async.pathExists(container + "/" + directory + "/");
    }

    @Override
    public ListenableFuture<Void> deleteDirectory(String containerName, String directory) {
        return this.removeBlob(containerName, directory + "/");
    }

    @Override
    public ListenableFuture<Boolean> blobExists(String container, String key) {
        return this.async.pathExists(container + "/" + key);
    }

    @Override
    public ListenableFuture<Blob> getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        ListenableFuture<AtmosObject> returnVal = this.async.readFile(container + "/" + key, httpOptions);
        return Futures.compose(returnVal, this.object2Blob, this.service);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.compose(this.async.listDirectories(new ListOptions[0]), this.container2ResourceList, this.service);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container, ListContainerOptions options) {
        container = AtmosUtils.adjustContainerIfDirOptionPresent(container, options);
        ListOptions nativeOptions = this.container2ContainerListOptions.apply(options);
        ListenableFuture<BoundedSet<? extends DirectoryEntry>> returnVal = this.async.listDirectory(container, nativeOptions);
        ListenableFuture<PageSet<? extends StorageMetadata>> list = Futures.compose(returnVal, this.container2ResourceList, this.service);
        return options.isDetailed() ? Futures.compose(list, this.fetchBlobMetadataProvider.get().setContainerName(container), this.service) : list;
    }

    @Override
    public ListenableFuture<String> putBlob(final String container, final Blob blob) {
        final PutOptions options = new PutOptions();
        try {
            if (this.isPublic.getUnchecked(container + "/").booleanValue()) {
                options.publicRead();
            }
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            // empty catch block
        }
        return Futures.makeListenable(this.service.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AtmosUtils.putBlob(AtmosAsyncBlobStore.this.sync, AtmosAsyncBlobStore.this.crypto, AtmosAsyncBlobStore.this.blob2Object, container, blob, options);
            }

            public String toString() {
                return "putBlob(" + container + "," + blob.getMetadata().getName() + ")";
            }
        }), this.service);
    }

    @Override
    public ListenableFuture<Void> removeBlob(String container, String key) {
        return this.async.deletePath(container + "/" + key);
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob, org.jclouds.blobstore.options.PutOptions options) {
        return this.putBlob(container, blob);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            return Futures.compose(this.async.createDirectory(container, PutOptions.Builder.publicRead()), new Function<URI, Boolean>(){

                @Override
                public Boolean apply(URI from) {
                    return true;
                }
            }, this.service);
        }
        return this.createContainerInLocation(location, container);
    }
}

