/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.firewall;

import java.io.IOException;
import java.util.Set;
import org.fusesource.fabric.service.jclouds.firewall.ProviderFirewallSupport;
import org.fusesource.fabric.service.jclouds.firewall.Rule;
import org.jclouds.compute.ComputeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirewallManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirewallManager.class);
    private final ComputeService computeService;
    private final ProviderFirewallSupport firewallSupport;

    public FirewallManager(ComputeService computeService, ProviderFirewallSupport firewallSupport) {
        this.computeService = computeService;
        this.firewallSupport = firewallSupport;
    }

    public void addRules(Rule ... rules) throws IOException {
        for (Rule rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRules(Set<Rule> rules) throws IOException {
        for (Rule rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRule(Rule rule) throws IOException {
        switch (rule.getType()) {
            case FLUSH: {
                this.firewallSupport.flush(this.computeService, rule.getDestination());
                break;
            }
            case AUTHORIZE: {
                this.firewallSupport.authorize(this.computeService, rule.getDestination(), rule.getSource(), rule.getPorts());
                break;
            }
            case REVOKE: {
                this.firewallSupport.revoke(this.computeService, rule.getDestination(), rule.getSource(), rule.getPorts());
                break;
            }
        }
    }

    public boolean isSupported() {
        return this.firewallSupport != null;
    }
}

