/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWithKeyCompleter
implements Completer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigWithKeyCompleter.class);
    private final StringsCompleter delegate = new StringsCompleter();
    private ConfigurationAdmin admin;

    public void setAdmin(ConfigurationAdmin admin) {
        this.admin = admin;
    }

    public void init() {
        Configuration[] configs;
        try {
            configs = this.admin.listConfigurations(null);
            if (configs == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        ArrayList pids = new ArrayList();
        for (Configuration config : configs) {
            this.delegate.getStrings().addAll(this.getPidWithKeys(config.getPid()));
        }
    }

    public int complete(String buffer, int cursor, List candidates) {
        int firstPass = this.delegate.complete(buffer, cursor, candidates);
        if (firstPass < 0) {
            this.updateAllPids();
            return this.delegate.complete(buffer, cursor, candidates);
        }
        return firstPass;
    }

    private void updateAllPids() {
        Configuration[] configurations = null;
        try {
            configurations = this.admin.listConfigurations(null);
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    this.delegate.getStrings().addAll(this.getPidWithKeys(configuration.getPid()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not lookup pids from configuration admin.");
        }
    }

    private Set<String> getPidWithKeys(String pid) {
        LinkedHashSet<String> pidWithKeys = new LinkedHashSet<String>();
        try {
            Dictionary dictionary;
            Configuration[] configuration = this.admin.listConfigurations("(service.pid=" + pid + ")");
            if (configuration != null && configuration.length > 0 && (dictionary = configuration[0].getProperties()) != null) {
                Enumeration keyEnumeration = dictionary.keys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = (String)keyEnumeration.nextElement();
                    pidWithKeys.add(pid + "/" + key);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not lookup pid {} from configuration admin.", (Object)pid);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.warn("Could not lookup pid {} from configuration admin.", (Object)pid);
        }
        return pidWithKeys;
    }
}

