/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.boot.commands.support;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.zookeeper.IZKClient;

public class ContainerAwareProfileCompleter
implements Completer {
    private final int containerArgumentIndex;
    private final boolean assigned;
    private final boolean unassigned;
    protected FabricService fabricService;
    protected IZKClient zooKeeper;

    public ContainerAwareProfileCompleter(int containerArgumentIndex, boolean assigned, boolean unassigned) {
        this.containerArgumentIndex = containerArgumentIndex;
        this.assigned = assigned;
        this.unassigned = unassigned;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        String versionName = null;
        try {
            Version defaultVersion = this.fabricService.getDefaultVersion();
            if (defaultVersion != null) {
                versionName = defaultVersion.getName();
            }
            if (versionName == null) {
                versionName = "1.0";
            }
            Container container = this.fabricService.getCurrentContainer();
            try {
                container = this.fabricService.getContainer(this.getContainer(CommandSessionHolder.getSession(), this.containerArgumentIndex));
            }
            catch (Exception ex) {
                // empty catch block
            }
            Profile[] containerProfiles = container.getProfiles();
            LinkedList<String> containerProfileNames = new LinkedList<String>();
            if (containerProfiles != null) {
                for (Profile p : containerProfiles) {
                    containerProfileNames.add(p.getId());
                }
            }
            Profile[] profiles = this.fabricService.getProfiles(versionName);
            LinkedList<String> allProfileNames = new LinkedList<String>();
            if (containerProfiles != null) {
                for (Profile p : profiles) {
                    allProfileNames.add(p.getId());
                }
            }
            if (this.assigned && this.unassigned) {
                delegate.getStrings().addAll(allProfileNames);
            } else if (this.assigned) {
                delegate.getStrings().addAll(containerProfileNames);
            } else if (this.unassigned) {
                allProfileNames.removeAll(containerProfileNames);
                delegate.getStrings().addAll(allProfileNames);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    private String getContainer(CommandSession commandSession, int index) {
        List<String> arguments;
        String containerName = System.getProperty("karaf.name");
        ArgumentCompleter.ArgumentList list = (ArgumentCompleter.ArgumentList)commandSession.get("ARGUMENTS_LIST");
        if (list != null && list.getArguments() != null && list.getArguments().length > 0 && (arguments = Arrays.asList(list.getArguments())).size() > index) {
            containerName = arguments.get(index);
        }
        return containerName;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

