/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VAppTemplateImpl;
import org.jclouds.trmk.vcloud_0_8.util.Utils;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VAppTemplateHandler
extends ParseSax.HandlerWithResult<VAppTemplate> {
    private StringBuilder currentText = new StringBuilder();
    private ReferenceType catalog;
    private String description;
    private Status status;

    @Override
    public VAppTemplate getResult() {
        return new VAppTemplateImpl(this.catalog.getName(), this.catalog.getHref(), this.description, this.status);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (qName.equals("VAppTemplate")) {
            this.catalog = Utils.newReferenceType(attributes);
            if (attributes.containsKey("status")) {
                this.status = Status.fromValue(attributes.get("status"));
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Description")) {
            this.description = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

