/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.options;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.trmk.vcloud_0_8.binders.BindAddNodeServiceToXmlPayload;

public class AddNodeOptions
extends BindAddNodeServiceToXmlPayload {
    @VisibleForTesting
    String description = null;
    @VisibleForTesting
    String enabled = "true";

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap<String, Object> copy = Maps.newHashMap();
        copy.putAll(postParams);
        copy.put("description", this.description);
        copy.put("enabled", this.enabled);
        return super.bindToRequest(request, copy);
    }

    public AddNodeOptions disabled() {
        this.enabled = "false";
        return this;
    }

    public AddNodeOptions withDescription(String description) {
        this.description = description;
        return this;
    }

    public static class Builder {
        public static AddNodeOptions withDescription(String description) {
            AddNodeOptions options = new AddNodeOptions();
            return options.withDescription(description);
        }

        public static AddNodeOptions disabled() {
            AddNodeOptions options = new AddNodeOptions();
            return options.disabled();
        }
    }
}

