/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

public abstract class OrgURIToEndpoint
implements Function<Object, URI> {
    protected final Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap;
    protected final Supplier<ReferenceType> defaultOrg;

    public OrgURIToEndpoint(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgMap, @Org Supplier<ReferenceType> defaultUri) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultUri;
    }

    @Override
    public URI apply(Object from) {
        ImmutableMap<URI, org.jclouds.trmk.vcloud_0_8.domain.Org> uriToOrg = Maps.uniqueIndex(this.orgMap.get().values(), new Function<org.jclouds.trmk.vcloud_0_8.domain.Org, URI>(){

            @Override
            public URI apply(org.jclouds.trmk.vcloud_0_8.domain.Org from) {
                return from.getHref();
            }
        });
        try {
            org.jclouds.trmk.vcloud_0_8.domain.Org org = (org.jclouds.trmk.vcloud_0_8.domain.Org)uriToOrg.get(from == null ? this.defaultOrg.get().getHref() : from);
            return this.getUriFromOrg(org);
        }
        catch (NullPointerException e) {
            throw new ResourceNotFoundException("org " + from + " not found in: " + uriToOrg, e);
        }
    }

    protected abstract URI getUriFromOrg(org.jclouds.trmk.vcloud_0_8.domain.Org var1);
}

