/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.slicehost.filters;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.annotations.Identity;

@Singleton
public class SlicehostBasic
implements HttpRequestFilter {
    private final String apikey;

    @Inject
    public SlicehostBasic(@Identity String apikey) {
        this.apikey = Preconditions.checkNotNull(apikey, "apikey");
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", String.format("Basic %s", CryptoStreams.base64(this.apikey.getBytes())))).build();
    }
}

