/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public class GeneratedHttpRequest
extends HttpRequest {
    private final Class<?> declaring;
    private final Method javaMethod;
    private final List<Object> args;
    private final Optional<ClassMethodArgs> caller;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromGeneratedHttpRequest(this);
    }

    protected GeneratedHttpRequest(String method, URI endpoint, Multimap<String, String> headers, @Nullable Payload payload, Class<?> declaring, Method javaMethod, Iterable<Object> args, Iterable<Character> skips, Iterable<HttpRequestFilter> filters, Optional<ClassMethodArgs> caller) {
        super(method, endpoint, headers, payload, skips, filters);
        this.declaring = Preconditions.checkNotNull(declaring, "declaring");
        this.javaMethod = Preconditions.checkNotNull(javaMethod, "javaMethod");
        this.args = Lists.newArrayList(Preconditions.checkNotNull(args, "args"));
        this.caller = Preconditions.checkNotNull(caller, "caller");
    }

    public Class<?> getDeclaring() {
        return this.declaring;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public List<Object> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public Optional<ClassMethodArgs> getCaller() {
        return this.caller;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends HttpRequest.Builder<T> {
        protected Class<?> declaring;
        protected Method javaMethod;
        protected List<Object> args = Lists.newArrayList();
        protected Optional<ClassMethodArgs> caller = Optional.absent();

        public T declaring(Class<?> declaring) {
            this.declaring = Preconditions.checkNotNull(declaring, "declaring");
            return (T)((Builder)this.self());
        }

        public T javaMethod(Method javaMethod) {
            this.javaMethod = Preconditions.checkNotNull(javaMethod, "javaMethod");
            return (T)((Builder)this.self());
        }

        public T args(Iterable<Object> args) {
            this.args = Lists.newArrayList(Preconditions.checkNotNull(args, "args"));
            return (T)((Builder)this.self());
        }

        public T args(@Nullable Object[] args) {
            return this.args(Arrays.asList(args != null ? args : new Object[]{}));
        }

        public T arg(@Nullable Object arg) {
            this.args.add(arg);
            return (T)((Builder)this.self());
        }

        public T caller(@Nullable ClassMethodArgs caller) {
            this.caller = Optional.fromNullable(caller);
            return (T)((Builder)this.self());
        }

        @Override
        public GeneratedHttpRequest build() {
            return new GeneratedHttpRequest(this.method, this.endpoint, this.headers.build(), this.payload, this.declaring, this.javaMethod, this.args, this.skips.build(), this.filters.build(), this.caller);
        }

        public T fromGeneratedHttpRequest(GeneratedHttpRequest in) {
            return ((Builder)((Builder)((Builder)((Builder)super.fromHttpRequest(in)).declaring(in.getDeclaring())).javaMethod(in.getJavaMethod())).args(in.getArgs())).caller(in.getCaller().orNull());
        }
    }
}

