/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers;

import com.google.common.base.Joiner;
import java.net.URI;
import java.util.Properties;
import org.jclouds.cloudloadbalancers.CloudLoadBalancersApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

public class CloudLoadBalancersUSProviderMetadata
extends BaseProviderMetadata {
    private static final long serialVersionUID = -1336822093264044850L;
    public static final String[] REGIONS = new String[]{"ORD", "DFW"};

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return CloudLoadBalancersUSProviderMetadata.builder().fromProviderMetadata(this);
    }

    public CloudLoadBalancersUSProviderMetadata() {
        super(CloudLoadBalancersUSProviderMetadata.builder());
    }

    public CloudLoadBalancersUSProviderMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.endpoint", "https://auth.api.rackspacecloud.com");
        properties.setProperty("jclouds.regions", Joiner.on(',').join(REGIONS));
        properties.setProperty("jclouds.iso3166-codes", "US-IL,US-TX");
        properties.setProperty("jclouds.region.ORD.iso3166-codes", "US-IL");
        properties.setProperty("jclouds.region.ORD.endpoint", String.format("https://ord.loadbalancers.api.rackspacecloud.com/v${%s}", "jclouds.api-version"));
        properties.setProperty("jclouds.region.DFW.iso3166-codes", "US-TX");
        properties.setProperty("jclouds.region.DFW.endpoint", String.format("https://dfw.loadbalancers.api.rackspacecloud.com/v${%s}", "jclouds.api-version"));
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("cloudloadbalancers-us").name("Rackspace Cloud Load Balancers US").apiMetadata(new CloudLoadBalancersApiMetadata()).homepage(URI.create("http://www.rackspace.com/cloud/cloud_hosting_products/loadbalancers")).console(URI.create("https://manage.rackspacecloud.com")).linkedServices("cloudloadbalancers-us", "cloudservers-us", "cloudfiles-us").iso3166Codes("US-IL", "US-TX").endpoint("https://auth.api.rackspacecloud.com");
        }

        @Override
        public CloudLoadBalancersUSProviderMetadata build() {
            return new CloudLoadBalancersUSProviderMetadata(this);
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

