/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.functions;

import com.google.common.base.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.functions.internal.BaseAuthenticator;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationApi;
import org.jclouds.rackspace.cloudidentity.v2_0.domain.ApiKeyCredentials;

@CredentialType(value="RAX-KSKEY:apiKeyCredentials")
@Singleton
public class AuthenticateApiKeyCredentials
extends BaseAuthenticator<ApiKeyCredentials> {
    protected final CloudIdentityAuthenticationApi api;

    @Inject
    public AuthenticateApiKeyCredentials(CloudIdentityAuthenticationApi api) {
        this.api = api;
    }

    @Override
    protected Access authenticateWithTenantName(Optional<String> tenantId, ApiKeyCredentials apiKeyCredentials) {
        return this.api.authenticateWithTenantNameAndCredentials(tenantId.orNull(), apiKeyCredentials);
    }

    @Override
    protected Access authenticateWithTenantId(Optional<String> tenantId, ApiKeyCredentials apiKeyCredentials) {
        return this.api.authenticateWithTenantIdAndCredentials(tenantId.orNull(), apiKeyCredentials);
    }

    @Override
    public ApiKeyCredentials createCredentials(String identity, String credential) {
        return ApiKeyCredentials.createWithUsernameAndApiKey(identity, credential);
    }

    public String toString() {
        return "authenticateApiKeyCredentials()";
    }
}

