/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.config;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.date.TimeStamp;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.openstack.swift.SwiftKeystoneAsyncClient;
import org.jclouds.openstack.swift.TemporaryUrlKey;
import org.jclouds.openstack.swift.blobstore.SwiftBlobSigner;
import org.jclouds.openstack.swift.extensions.KeystoneTemporaryUrlKeyAsyncApi;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyApi;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyAsyncApi;
import org.jclouds.openstack.swift.suppliers.ReturnOrFetchTemporaryUrlKey;
import org.jclouds.rest.config.BinderUtils;

public abstract class TemporaryUrlExtensionModule<A extends CommonSwiftAsyncClient>
extends AbstractModule {
    @Provides
    @TimeStamp
    protected Long unixEpochTimestampProvider() {
        return System.currentTimeMillis() / 1000L;
    }

    @Override
    protected void configure() {
        this.bindRequestSigner();
        this.bindTemporaryUrlKeyApi();
        this.bind(new TypeLiteral<Supplier<String>>(){}).annotatedWith(TemporaryUrlKey.class).to(ReturnOrFetchTemporaryUrlKey.class);
    }

    protected abstract void bindRequestSigner();

    protected void bindTemporaryUrlKeyApi() {
        BinderUtils.bindClientAndAsyncClient(this.binder(), TemporaryUrlKeyApi.class, TemporaryUrlKeyAsyncApi.class);
    }

    public static class SwiftKeystoneTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<SwiftKeystoneAsyncClient> {
        @Override
        protected void bindTemporaryUrlKeyApi() {
            BinderUtils.bindClientAndAsyncClient(this.binder(), TemporaryUrlKeyApi.class, KeystoneTemporaryUrlKeyAsyncApi.class);
        }

        @Override
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral<BlobRequestSigner>)new TypeLiteral<SwiftBlobSigner<SwiftKeystoneAsyncClient>>(){});
        }
    }

    public static class SwiftTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<SwiftAsyncClient> {
        @Override
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral<BlobRequestSigner>)new TypeLiteral<SwiftBlobSigner<SwiftAsyncClient>>(){});
        }
    }
}

