/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.features.ImageApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseImageDetails
extends ParseJson<Images<? extends Image>> {
    @Inject
    public ParseImageDetails(Json json) {
        super(json, new TypeLiteral<Images<? extends Image>>(){});
    }

    public static class ToPagedIterable
    extends CallerArg0ToPagedIterable<Image, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = Preconditions.checkNotNull(api, "api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Image>> markerToNextForCallingArg0(String zone) {
            final ImageApi imageApi = this.api.getImageApiForZone(zone);
            return new Function<Object, IterableWithMarker<Image>>(){

                @Override
                public IterableWithMarker<Image> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(imageApi.listInDetail(PaginationOptions.Builder.marker(input.toString())));
                }

                public String toString() {
                    return "listInDetail()";
                }
            };
        }
    }

    static class Images<T extends Image>
    extends PaginatedCollection<T> {
        @ConstructorProperties(value={"images", "images_links"})
        protected Images(Iterable<T> images, Iterable<Link> images_links) {
            super(images, images_links);
        }
    }
}

