/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Host;
import org.jclouds.openstack.nova.v2_0.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v2_0.functions.FieldValueResponseParsers;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptyFluentIterableOnNotFoundOr404;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/hosts/api/v1.1")
@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/os-hosts")
@Consumes(value={"application/json"})
@Beta
public interface HostAdministrationAsyncApi {
    @GET
    @SelectJson(value="hosts")
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Host>> list();

    @GET
    @Path(value="/{id}")
    @SelectJson(value="host")
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends HostResourceUsage>> listResourceUsage(@PathParam(value="id") String var1);

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"status\":\"enable\"}")
    @ResponseParser(value=FieldValueResponseParsers.StatusEnabledResponseParser.class)
    public ListenableFuture<Boolean> enable(@PathParam(value="id") String var1);

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"status\":\"disable\"}")
    @ResponseParser(value=FieldValueResponseParsers.StatusDisabledResponseParser.class)
    public ListenableFuture<Boolean> disable(@PathParam(value="id") String var1);

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"maintenance_mode\":\"enable\"}")
    @ResponseParser(value=FieldValueResponseParsers.MaintenanceModeEnabledResponseParser.class)
    public ListenableFuture<Boolean> startMaintenance(@PathParam(value="id") String var1);

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Payload(value="{\"maintenance_mode\":\"disable\"}")
    @ResponseParser(value=FieldValueResponseParsers.MaintenanceModeDisabledResponseParser.class)
    public ListenableFuture<Boolean> stopMaintenance(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/startup")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsStartupResponseParser.class)
    public ListenableFuture<Boolean> startup(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/shutdown")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsShutdownResponseParser.class)
    public ListenableFuture<Boolean> shutdown(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/reboot")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsRebootResponseParser.class)
    public ListenableFuture<Boolean> reboot(@PathParam(value="id") String var1);
}

