/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ServerCreated
extends Resource {
    private final String adminPass;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerCreated(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "adminPass"})
    protected ServerCreated(String id, @Nullable String name, Set<Link> links, String adminPass) {
        super(id, name, links);
        this.adminPass = Preconditions.checkNotNull(adminPass, "adminPass");
    }

    public String getAdminPass() {
        return this.adminPass;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.adminPass);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerCreated that = (ServerCreated)ServerCreated.class.cast(obj);
        return super.equals(that) && Objects.equal(this.adminPass, that.adminPass);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("adminPass", this.adminPass);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String adminPass;

        public T adminPass(String adminPass) {
            this.adminPass = adminPass;
            return (T)((Builder)this.self());
        }

        @Override
        public ServerCreated build() {
            return new ServerCreated(this.id, this.name, this.links, this.adminPass);
        }

        public T fromServerCreated(ServerCreated in) {
            return ((Builder)super.fromResource(in)).adminPass(in.getAdminPass());
        }
    }
}

