/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class BindSecurityGroupRuleToJsonPayload
extends BindToJsonPayload
implements MapBinder {
    @Inject
    public BindSecurityGroupRuleToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindCredentialsToJsonPayload needs parameters");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ImmutableMap.Builder<String, Object> payload = ImmutableMap.builder();
        payload.putAll(postParams);
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Ingress ingress = (Ingress)Ingress.class.cast(Iterables.find(gRequest.getArgs(), Predicates.instanceOf(Ingress.class)));
        payload.put("ip_protocol", ingress.getIpProtocol().toString());
        payload.put("from_port", ingress.getFromPort() + "");
        payload.put("to_port", ingress.getToPort() + "");
        return super.bindToRequest(request, (Object)ImmutableMap.of("security_group_rule", payload.build()));
    }
}

