/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.nodepool.internal.NodeMetadataStore;
import org.jclouds.util.Strings2;

@Singleton
public class JsonNodeMetadataStore
implements NodeMetadataStore {
    private Supplier<Map<String, InputStream>> storage;
    private final Json json;

    @Inject
    public JsonNodeMetadataStore(@Named(value="METADATA") Supplier<Map<String, InputStream>> storage, Json json) {
        this.storage = storage;
        this.json = json;
    }

    @Override
    public NodeMetadata store(NodeMetadata backendNodeMetadata, TemplateOptions userOptions, String userGroup) {
        Preconditions.checkNotNull(backendNodeMetadata);
        Preconditions.checkNotNull(userGroup);
        Preconditions.checkNotNull(userOptions);
        Preconditions.checkNotNull(userOptions.getLoginUser());
        Preconditions.checkState(userOptions.getLoginPassword() != null || userOptions.getLoginPrivateKey() != null);
        JsonUserNodeMetadata jsonMetadata = new JsonUserNodeMetadata();
        jsonMetadata.user = userOptions.getLoginUser();
        jsonMetadata.password = userOptions.getLoginPassword();
        jsonMetadata.privateKey = userOptions.getLoginPrivateKey();
        jsonMetadata.authenticateSudo = userOptions.shouldAuthenticateSudo() != null ? userOptions.shouldAuthenticateSudo() : false;
        jsonMetadata.userMetadata = userOptions.getUserMetadata();
        jsonMetadata.tags = userOptions.getTags();
        jsonMetadata.group = userGroup;
        this.storage.get().put(backendNodeMetadata.getId(), Strings2.toInputStream(this.json.toJson(jsonMetadata)));
        return this.buildFromJsonAndBackendMetadata(backendNodeMetadata, jsonMetadata);
    }

    @Override
    public NodeMetadata load(NodeMetadata backendNodeMetadata) {
        try {
            InputStream storedMetadata = this.storage.get().get(Preconditions.checkNotNull(backendNodeMetadata).getId());
            if (storedMetadata == null) {
                return null;
            }
            String jsonMetadataAsString = Strings2.toStringAndClose(storedMetadata);
            JsonUserNodeMetadata jsonMetadata = this.json.fromJson(jsonMetadataAsString, JsonUserNodeMetadata.class);
            return this.buildFromJsonAndBackendMetadata(backendNodeMetadata, jsonMetadata);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public Set<NodeMetadata> loadAll(Set<NodeMetadata> backendNodes) {
        if (backendNodes == null || backendNodes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<NodeMetadata> loadedSet = Sets.newLinkedHashSet();
        for (NodeMetadata input : backendNodes) {
            NodeMetadata loaded = this.load(input);
            if (loaded == null) continue;
            loadedSet.add(loaded);
        }
        return loadedSet;
    }

    private NodeMetadata buildFromJsonAndBackendMetadata(NodeMetadata backendNodeMetadata, JsonUserNodeMetadata jsonMetadata) {
        return ((NodeMetadataBuilder)((NodeMetadataBuilder)NodeMetadataBuilder.fromNodeMetadata(backendNodeMetadata).tags((Iterable)jsonMetadata.tags)).group(jsonMetadata.group).userMetadata(jsonMetadata.userMetadata)).credentials(new LoginCredentials(jsonMetadata.user, jsonMetadata.password, jsonMetadata.privateKey, jsonMetadata.authenticateSudo)).build();
    }

    @Override
    public void deleteAllMappings() {
        this.storage.get().clear();
    }

    @Override
    public void deleteMapping(String backendNodeId) {
        this.storage.get().remove(backendNodeId);
    }

    private static class JsonUserNodeMetadata {
        private String group;
        private Set<String> tags;
        private Map<String, String> userMetadata;
        private String user;
        private String password;
        private String privateKey;
        private boolean authenticateSudo;

        private JsonUserNodeMetadata() {
        }
    }
}

