/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.JCloudsNativeComputeServiceAdapter;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.nodepool.Backend;
import org.jclouds.nodepool.internal.BaseNodePoolComputeServiceAdapter;
import org.jclouds.nodepool.internal.NodeMetadataStore;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

@Singleton
public class EagerNodePoolComputeServiceAdapter
extends BaseNodePoolComputeServiceAdapter {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final int maxSize;
    private final int minSize;
    private final boolean removeDestroyed;

    @Inject
    public EagerNodePoolComputeServiceAdapter(@Backend Supplier<ComputeService> backendComputeService, @Backend Supplier<Template> backendTemplate, @Named(value="jclouds.nodepool.backend-group") String poolGroupPrefix, @Named(value="jclouds.nodepool.max-size") int maxSize, @Named(value="jclouds.nodepool.min-size") int minSize, @Named(value="jclouds.nodepool.remove-destroyed") boolean removeDestroyed, NodeMetadataStore storage, @Named(value="jclouds.nodepool.admin-access") String poolNodeAdminAccess, AdminAccess.Configuration configuration) {
        super(backendComputeService, backendTemplate, poolGroupPrefix, storage, poolNodeAdminAccess, configuration);
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.removeDestroyed = removeDestroyed;
    }

    @PostConstruct
    public void startEagerPool() {
        Set<NodeMetadata> backendNodes = this.getBackendNodes();
        int currentNodes = backendNodes.size();
        int newNodes = backendNodes.size() < this.minSize ? this.minSize - backendNodes.size() : 0;
        this.logger.info(">> initializing nodepool [backend provider: %s]. [existing nodes: %s, min nodes: %s, allocating: %s ]", ((ComputeService)this.backendComputeService.get()).getClass().getSimpleName(), currentNodes, this.minSize, newNodes);
        if (backendNodes.size() < this.minSize) {
            this.addToPool(this.minSize - backendNodes.size());
        }
        this.logger.info("<< pool initialized.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCloudsNativeComputeServiceAdapter.NodeWithInitialCredentials createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        int count = 1;
        EagerNodePoolComputeServiceAdapter eagerNodePoolComputeServiceAdapter = this;
        synchronized (eagerNodePoolComputeServiceAdapter) {
            TemplateOptions options = template.getOptions().clone();
            if (options.getLoginUser() == null) {
                options.overrideLoginCredentials(LoginCredentials.fromCredentials(Preconditions.checkNotNull(this.initialCredentialsBuilder.build().getAdminCredentials())));
            }
            this.logger.info(">> assigning pool node to frontend group %s", group);
            Set<NodeMetadata> backendNodes = this.getBackendNodes();
            Preconditions.checkState(!backendNodes.isEmpty());
            Set<NodeMetadata> frontendNodes = this.metadataStore.loadAll(backendNodes);
            Preconditions.checkState(frontendNodes.size() + count <= this.maxSize, "cannot add more nodes to pool [requested: %s, current: %s, max: %s]", count, frontendNodes.size(), this.maxSize);
            Sets.SetView<NodeMetadata> availableNodes = Sets.difference(backendNodes, frontendNodes);
            if (availableNodes.size() < 1) {
                if (backendNodes.size() < this.maxSize && backendNodes.size() + count <= this.maxSize) {
                    this.logger.info(">> all pool nodes are assigned, requiring additional nodes [requested: %s, current: %s, next: %s, max: %s]", count, frontendNodes.size(), frontendNodes.size() + 1, this.maxSize);
                    this.addToPool(count);
                    backendNodes = this.getBackendNodes();
                    availableNodes = Sets.difference(backendNodes, frontendNodes);
                    this.logger.info("<< additional nodes added to the pool and ready", new Object[0]);
                } else {
                    this.logger.error("maximum pool size reached (%s)", this.maxSize);
                    throw new IllegalStateException(String.format("maximum pool size reached (%s)", this.maxSize));
                }
            }
            NodeMetadata userNode = Iterables.get(availableNodes, 0);
            NodeMetadata node = this.metadataStore.store(userNode, options, group);
            this.logger.info("pool node assigned", new Object[0]);
            return new JCloudsNativeComputeServiceAdapter.NodeWithInitialCredentials(node);
        }
    }

    @Override
    public synchronized void destroyNode(String id) {
        Preconditions.checkState(this.getNode(id) != null);
        this.logger.info(">> destroying node %s", id);
        this.metadataStore.deleteMapping(id);
        if (this.removeDestroyed) {
            ((ComputeService)this.backendComputeService.get()).destroyNode(id);
            if (this.currentSize() < this.minSize) {
                this.logger.info(">> policy is remove destroyed node and pool would fall below minsize, replacing node with id %s", id);
                Set<? extends NodeMetadata> replacement = this.addToPool(1);
                this.logger.info("<< node %s replaced with %s", id, Iterables.getOnlyElement(replacement));
            }
        }
        this.logger.info("<< node destroyed %s", id);
    }

    @Override
    public int currentSize() {
        return this.getBackendNodes().size();
    }

    @Override
    public int idleNodes() {
        Set<NodeMetadata> backendNodes = this.getBackendNodes();
        Set<NodeMetadata> frontendNodes = this.metadataStore.loadAll(backendNodes);
        return backendNodes.size() - frontendNodes.size();
    }

    @Override
    public int maxNodes() {
        return this.maxSize;
    }

    @Override
    public int minNodes() {
        return this.minSize;
    }

    @Override
    public int usedNodes() {
        return this.metadataStore.loadAll(this.getBackendNodes()).size();
    }
}

