/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.nodepool.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Exposed;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.jclouds.lifecycle.Closer;
import org.jclouds.location.Provider;
import org.jclouds.nodepool.Backend;
import org.jclouds.nodepool.config.BindJcloudsModules;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.util.Predicates2;

public class BindBackendComputeService
extends BindJcloudsModules {
    private static final Predicate<String> keys = Predicates.and(Predicates.not(Predicates2.startsWith("jclouds.nodepool")), Predicates.not(Predicates2.startsWith("nodepool")));

    @Provides
    @Singleton
    @Backend
    protected String provideBackendProvider(@Named(value="jclouds.nodepool.backend-provider") String provider) {
        return provider;
    }

    @Provides
    @Singleton
    @Backend
    @Exposed
    protected Supplier<ComputeService> makeBackendComputeService(final @Backend String provider, final @Backend Set<Module> modules, final @Provider Credentials creds, final @Backend Supplier<Properties> overrides, final Closer closer) {
        return Suppliers.memoize(new Supplier<ComputeService>(){

            @Override
            public ComputeService get() {
                ComputeServiceContext ctx = ContextBuilder.newBuilder(provider).credentials(creds.identity, creds.credential).overrides((Properties)overrides.get()).modules(modules).buildView(ComputeServiceContext.class);
                closer.addToClose(ctx);
                return ctx.getComputeService();
            }
        });
    }

    @Provides
    @Singleton
    @Backend
    protected Supplier<Properties> propertiesFor(final FilterStringsBoundToInjectorByName filterStringsBoundByName, final @Backend String provider, final @Provider Supplier<URI> endpoint, final @ApiVersion String apiVersion, final @BuildVersion String buildVersion) {
        return Suppliers.memoize(new Supplier<Properties>(){

            @Override
            public Properties get() {
                Properties props = new Properties();
                props.putAll(filterStringsBoundByName.apply(keys));
                props.put(provider + ".endpoint", ((URI)endpoint.get()).toASCIIString());
                props.put(provider + ".api-version", apiVersion);
                props.put(provider + ".build-version", buildVersion);
                return props;
            }
        });
    }

    @Provides
    @Exposed
    @Singleton
    protected TemplateBuilder templateBuilder(@Backend Supplier<ComputeService> compute, final @Backend Supplier<Template> template) {
        try {
            compute.get().templateBuilder().build();
            return compute.get().templateBuilder();
        }
        catch (Exception e) {
            return new TemplateBuilder(){

                @Override
                public TemplateBuilder smallest() {
                    return this;
                }

                @Override
                public TemplateBuilder osVersionMatches(String osVersionRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder osNameMatches(String osNameRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder osFamily(OsFamily os) {
                    return this;
                }

                @Override
                public TemplateBuilder osDescriptionMatches(String osDescriptionRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder osArchMatches(String architecture) {
                    return this;
                }

                @Override
                public TemplateBuilder os64Bit(boolean is64bit) {
                    return this;
                }

                @Override
                public TemplateBuilder options(TemplateOptions options) {
                    return this;
                }

                @Override
                public TemplateBuilder minRam(int megabytes) {
                    return this;
                }

                @Override
                public TemplateBuilder minDisk(double gigabytes) {
                    return this;
                }

                @Override
                public TemplateBuilder minCores(double minCores) {
                    return this;
                }

                @Override
                public TemplateBuilder locationId(String locationId) {
                    return this;
                }

                @Override
                public TemplateBuilder imageVersionMatches(String imageVersionRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder imageNameMatches(String imageNameRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder imageMatches(Predicate<Image> condition) {
                    return this;
                }

                @Override
                public TemplateBuilder imageId(String imageId) {
                    return this;
                }

                @Override
                public TemplateBuilder imageDescriptionMatches(String imageDescriptionRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder hypervisorMatches(String hypervisorRegex) {
                    return this;
                }

                @Override
                public TemplateBuilder hardwareId(String hardwareId) {
                    return this;
                }

                @Override
                public TemplateBuilder fromTemplate(Template image) {
                    return this;
                }

                @Override
                public TemplateBuilder fromImage(Image image) {
                    return this;
                }

                @Override
                public TemplateBuilder fromHardware(Hardware hardware) {
                    return this;
                }

                @Override
                @Beta
                public TemplateBuilder from(String spec) {
                    return this;
                }

                @Override
                @Beta
                public TemplateBuilder from(TemplateBuilderSpec spec) {
                    return this;
                }

                @Override
                public TemplateBuilder fastest() {
                    return this;
                }

                @Override
                public Template build() {
                    return (Template)template.get();
                }

                @Override
                public TemplateBuilder biggest() {
                    return this;
                }

                @Override
                public TemplateBuilder any() {
                    return this;
                }
            };
        }
    }

    @Provides
    @Singleton
    @Backend
    @Exposed
    protected Supplier<Template> makeBackendTemplate(@Backend Supplier<ComputeService> compute, final @Named(value="jclouds.nodepool.backend-group") String poolGroupPrefix) {
        return Suppliers.memoize(Suppliers.compose(new Function<ComputeService, Template>(){

            @Override
            public Template apply(ComputeService input) {
                try {
                    return input.templateBuilder().build();
                }
                catch (IllegalStateException e) {
                    Set<NodeMetadata> nodes = Sets.filter(input.listNodesDetailsMatching(NodePredicates.all()), NodePredicates.inGroup(poolGroupPrefix));
                    Preconditions.checkState(!nodes.isEmpty(), "service provided no template and no node was in this nodepool's group.");
                    final NodeMetadata node = Iterables.get(nodes, 0);
                    final Image image = new ImageBuilder().id(node.getId()).location(node.getLocation()).operatingSystem(node.getOperatingSystem()).status(Image.Status.AVAILABLE).description("physical node").build();
                    final Hardware hardware = new HardwareBuilder().id(node.getId()).build();
                    return new Template(){

                        @Override
                        public Image getImage() {
                            return image;
                        }

                        @Override
                        public Hardware getHardware() {
                            return hardware;
                        }

                        @Override
                        public Location getLocation() {
                            return node.getLocation();
                        }

                        @Override
                        public TemplateOptions getOptions() {
                            return new TemplateOptions();
                        }

                        @Override
                        public Template clone() {
                            return this;
                        }
                    };
                }
            }
        }, compute));
    }
}

