/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.core.internal;

import com.google.common.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.ApiPredicates;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.karaf.core.BlobStoreProviderOrApiListener;
import org.jclouds.karaf.core.ComputeProviderOrApiListener;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBundleListener
implements BundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataBundleListener.class);
    private Map<Long, ProviderMetadata> providerMetadataMap = new HashMap<Long, ProviderMetadata>();
    private Map<Long, ApiMetadata> apiMetadataMap = new HashMap<Long, ApiMetadata>();
    private Set<ProviderMetadata> computeProviders = new HashSet<ProviderMetadata>();
    private Set<ProviderMetadata> blobStoreProviders = new HashSet<ProviderMetadata>();
    private Set<ApiMetadata> computeApis = new HashSet<ApiMetadata>();
    private Set<ApiMetadata> blobStoreApis = new HashSet<ApiMetadata>();
    private final List<ComputeProviderOrApiListener> computeProviderOrApiListeners = new LinkedList<ComputeProviderOrApiListener>();
    private final List<BlobStoreProviderOrApiListener> blobStoreProviderOrApiListeners = new LinkedList<BlobStoreProviderOrApiListener>();
    private BundleContext bundleContext;

    public void init() {
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ApiMetadata apiMetadata;
            if (bundle.getState() != 32) continue;
            ProviderMetadata providerMetadata = this.getProviderMetadata(bundle);
            if (providerMetadata != null) {
                this.notifyInstallation(providerMetadata);
                this.providerMetadataMap.put(bundle.getBundleId(), providerMetadata);
            }
            if ((apiMetadata = this.getApiMetadata(bundle)) == null) continue;
            this.notifyInstallation(apiMetadata);
            this.apiMetadataMap.put(bundle.getBundleId(), apiMetadata);
        }
    }

    public void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                ProviderMetadata providerMetadata = this.getProviderMetadata(event.getBundle());
                ApiMetadata apiMetadata = this.getApiMetadata(event.getBundle());
                if (providerMetadata != null) {
                    this.notifyInstallation(providerMetadata);
                    this.providerMetadataMap.put(event.getBundle().getBundleId(), providerMetadata);
                }
                if (apiMetadata == null) break;
                this.notifyInstallation(apiMetadata);
                this.apiMetadataMap.put(event.getBundle().getBundleId(), apiMetadata);
                break;
            }
            case 4: 
            case 256: {
                ProviderMetadata providerMetadata = this.providerMetadataMap.remove(event.getBundle().getBundleId());
                ApiMetadata apiMetadata = this.apiMetadataMap.remove(event.getBundle().getBundleId());
                if (providerMetadata != null) {
                    this.notifyRemoval(providerMetadata);
                }
                if (apiMetadata == null) break;
                this.notifyRemoval(apiMetadata);
            }
        }
    }

    public ProviderMetadata getProviderMetadata(Bundle bundle) {
        ProviderMetadata metadata = null;
        String className = this.getProviderMetadataClassName(bundle);
        if (className != null && !className.isEmpty()) {
            try {
                Class providerMetadataClass = bundle.loadClass(className);
                metadata = (ProviderMetadata)providerMetadataClass.newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return metadata;
    }

    public ApiMetadata getApiMetadata(Bundle bundle) {
        ApiMetadata metadata = null;
        String className = this.getApiMetadataClassName(bundle);
        if (className != null && !className.isEmpty()) {
            try {
                Class apiMetadataClass = bundle.loadClass(className);
                metadata = (ApiMetadata)apiMetadataClass.newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadataClassName(Bundle bundle, String pathToMetadata) {
        URL resource = bundle.getEntry(pathToMetadata);
        InputStream is = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            is = resource.openStream();
            reader = new InputStreamReader(is, "UTF-8");
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Throwable e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable e) {}
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        return sb.toString().trim();
    }

    public String getProviderMetadataClassName(Bundle bundle) {
        return this.getMetadataClassName(bundle, "/META-INF/services/org.jclouds.providers.ProviderMetadata");
    }

    public String getApiMetadataClassName(Bundle bundle) {
        return this.getMetadataClassName(bundle, "/META-INF/services/org.jclouds.apis.ApiMetadata");
    }

    public void notifyInstallation(ProviderMetadata metadata) {
        block2: {
            block3: {
                if (metadata == null) break block2;
                if (!ProviderPredicates.viewableAs(TypeToken.of(ComputeServiceContext.class)).apply(metadata)) break block3;
                this.computeProviders.add(metadata);
                for (ComputeProviderOrApiListener providerOrApiListener : this.computeProviderOrApiListeners) {
                    providerOrApiListener.providerInstalled(metadata);
                }
                break block2;
            }
            if (!ProviderPredicates.viewableAs(TypeToken.of(BlobStoreContext.class)).apply(metadata)) break block2;
            this.blobStoreProviders.add(metadata);
            for (BlobStoreProviderOrApiListener providerOrApiListener : this.blobStoreProviderOrApiListeners) {
                providerOrApiListener.providerInstalled(metadata);
            }
        }
    }

    public void notifyInstallation(ApiMetadata metadata) {
        block2: {
            block3: {
                if (metadata == null) break block2;
                if (!ApiPredicates.viewableAs(TypeToken.of(ComputeServiceContext.class)).apply(metadata)) break block3;
                this.computeApis.add(metadata);
                for (ComputeProviderOrApiListener providerOrApiListener : this.computeProviderOrApiListeners) {
                    providerOrApiListener.apiInstalled(metadata);
                }
                break block2;
            }
            if (!ApiPredicates.viewableAs(TypeToken.of(BlobStoreContext.class)).apply(metadata)) break block2;
            this.blobStoreApis.add(metadata);
            for (BlobStoreProviderOrApiListener providerOrApiListener : this.blobStoreProviderOrApiListeners) {
                providerOrApiListener.apiInstalled(metadata);
            }
        }
    }

    private void notifyRemoval(ProviderMetadata metadata) {
        block2: {
            block3: {
                if (metadata == null) break block2;
                if (!ProviderPredicates.viewableAs(TypeToken.of(ComputeServiceContext.class)).apply(metadata)) break block3;
                this.computeProviders.remove(metadata);
                for (ComputeProviderOrApiListener providerOrApiListener : this.computeProviderOrApiListeners) {
                    providerOrApiListener.providerUninstalled(metadata);
                }
                break block2;
            }
            if (!ProviderPredicates.viewableAs(TypeToken.of(BlobStoreContext.class)).apply(metadata)) break block2;
            this.blobStoreProviders.remove(metadata);
            for (BlobStoreProviderOrApiListener providerOrApiListener : this.blobStoreProviderOrApiListeners) {
                providerOrApiListener.providerUninstalled(metadata);
            }
        }
    }

    private void notifyRemoval(ApiMetadata metadata) {
        block2: {
            block3: {
                if (metadata == null) break block2;
                if (!ApiPredicates.viewableAs(TypeToken.of(ComputeServiceContext.class)).apply(metadata)) break block3;
                this.computeApis.remove(metadata);
                for (ComputeProviderOrApiListener providerOrApiListener : this.computeProviderOrApiListeners) {
                    providerOrApiListener.apiUninstalled(metadata);
                }
                break block2;
            }
            if (!ApiPredicates.viewableAs(TypeToken.of(BlobStoreContext.class)).apply(metadata)) break block2;
            this.blobStoreApis.remove(metadata);
            for (BlobStoreProviderOrApiListener providerOrApiListener : this.blobStoreProviderOrApiListeners) {
                providerOrApiListener.apiUninstalled(metadata);
            }
        }
    }

    public void registerComputeListener(ComputeProviderOrApiListener providerOrApiListener) {
        this.computeProviderOrApiListeners.add(providerOrApiListener);
        for (ProviderMetadata provider : this.computeProviders) {
            providerOrApiListener.providerInstalled(provider);
        }
        for (ApiMetadata api : this.computeApis) {
            providerOrApiListener.apiInstalled(api);
        }
    }

    public void unregisterComputeListener(ComputeProviderOrApiListener providerOrApiListener) {
        if (providerOrApiListener != null) {
            this.computeProviderOrApiListeners.remove(providerOrApiListener);
            for (ProviderMetadata provider : this.computeProviders) {
                providerOrApiListener.providerUninstalled(provider);
            }
            for (ApiMetadata api : this.computeApis) {
                providerOrApiListener.apiUninstalled(api);
            }
        }
    }

    public void registerBlobStoreListener(BlobStoreProviderOrApiListener providerOrApiListener) {
        this.blobStoreProviderOrApiListeners.add(providerOrApiListener);
        for (ProviderMetadata provider : this.blobStoreProviders) {
            providerOrApiListener.providerInstalled(provider);
        }
        for (ApiMetadata api : this.blobStoreApis) {
            providerOrApiListener.apiInstalled(api);
        }
    }

    public void unregisterBlobStoreListener(BlobStoreProviderOrApiListener providerOrApiListener) {
        if (providerOrApiListener != null) {
            this.blobStoreProviderOrApiListeners.remove(providerOrApiListener);
            for (ProviderMetadata provider : this.blobStoreProviders) {
                providerOrApiListener.providerUninstalled(provider);
            }
            for (ApiMetadata api : this.computeApis) {
                providerOrApiListener.apiUninstalled(api);
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

