/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.reflect.TypeToken;
import javax.inject.Singleton;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.location.Provider;

@Singleton
public abstract class BaseView
extends ForwardingObject
implements View {
    private final Context backend;
    private final TypeToken<? extends Context> backendType;

    protected BaseView(@Provider Context backend, @Provider TypeToken<? extends Context> backendType) {
        this.backend = Preconditions.checkNotNull(backend, "backend");
        this.backendType = Preconditions.checkNotNull(backendType, "backendType");
    }

    @Override
    public <C extends Context> C unwrap(TypeToken<C> type) {
        Preconditions.checkArgument(Preconditions.checkNotNull(type, "type").isAssignableFrom(this.backendType), "backend type: %s not assignable from %s", this.backendType, type);
        return (C)this.backend;
    }

    @Override
    public <C extends Context> C unwrap(Class<C> clazz) {
        return this.unwrap(TypeToken.of(Preconditions.checkNotNull(clazz, "clazz")));
    }

    public TypeToken<? extends Context> getBackendType() {
        return this.backendType;
    }

    @Override
    public <C extends Context> C unwrap() throws ClassCastException {
        return (C)this.unwrap(this.getBackendType());
    }

    @Override
    protected Context delegate() {
        return this.backend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseView that = (BaseView)BaseView.class.cast(o);
        return Objects.equal(this.delegate(), that.delegate()) && Objects.equal(this.getBackendType(), that.getBackendType());
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate(), this.getBackendType());
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").add("backend", this.delegate()).add("backendType", this.getBackendType());
    }
}

