/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageAsyncApi;
import org.jclouds.hpcloud.objectstorage.blobstore.HPCloudObjectStorageBlobRequestSigner;
import org.jclouds.hpcloud.objectstorage.blobstore.config.HPCloudObjectStorageBlobStoreContextModule;
import org.jclouds.hpcloud.objectstorage.config.HPCloudObjectStorageRestClientModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.swift.SwiftKeystoneApiMetadata;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.openstack.swift.extensions.KeystoneTemporaryUrlKeyAsyncApi;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyApi;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.config.BinderUtils;

public class HPCloudObjectStorageApiMetadata
extends SwiftKeystoneApiMetadata {
    private static final long serialVersionUID = 820062881469203616L;
    public static final TypeToken<RestContext<HPCloudObjectStorageApi, HPCloudObjectStorageAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<HPCloudObjectStorageApi, HPCloudObjectStorageAsyncApi>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    private static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return HPCloudObjectStorageApiMetadata.builder().fromApiMetadata(this);
    }

    public HPCloudObjectStorageApiMetadata() {
        this(HPCloudObjectStorageApiMetadata.builder());
    }

    protected HPCloudObjectStorageApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = SwiftKeystoneApiMetadata.defaultProperties();
        return properties;
    }

    public static class HPCloudObjectStorageTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<HPCloudObjectStorageAsyncApi> {
        @Override
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to(HPCloudObjectStorageBlobRequestSigner.class);
        }

        @Override
        protected void bindTemporaryUrlKeyApi() {
            BinderUtils.bindClientAndAsyncClient(this.binder(), TemporaryUrlKeyApi.class, KeystoneTemporaryUrlKeyAsyncApi.class);
        }
    }

    public static class Builder
    extends SwiftKeystoneApiMetadata.Builder {
        protected Builder() {
            super(HPCloudObjectStorageApi.class, HPCloudObjectStorageAsyncApi.class);
            ((BaseApiMetadata.Builder)this.id("hpcloud-objectstorage").endpointName("identity service url ending in /v2.0/").defaultEndpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/").name("HP Cloud Services Object Storage API").documentation(URI.create("https://build.hpcloud.com/object-storage/api")).defaultProperties(HPCloudObjectStorageApiMetadata.defaultProperties()).context(CONTEXT_TOKEN)).defaultModules((Set)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(SwiftRestClientModule.KeystoneStorageEndpointModule.class)).add(KeystoneAuthenticationModule.RegionModule.class)).add(HPCloudObjectStorageRestClientModule.class)).add(HPCloudObjectStorageBlobStoreContextModule.class)).add(HPCloudObjectStorageTemporaryUrlExtensionModule.class)).build()));
        }

        @Override
        public HPCloudObjectStorageApiMetadata build() {
            return new HPCloudObjectStorageApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

