/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import java.util.Date;
import java.util.Map;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerMetrics;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.domain.VNC;
import org.jclouds.javax.annotation.Nullable;

public class ServerInfo
extends Server {
    protected final ServerStatus status;
    @Nullable
    protected final Date started;
    @Nullable
    protected final String user;
    protected final ServerMetrics metrics;

    public ServerInfo(String uuid, String name, int cpu, Integer smp, int mem, boolean persistent, Map<String, ? extends Device> devices, Iterable<String> bootDeviceIds, Iterable<String> tags, Map<String, String> userMetadata, Iterable<NIC> nics, VNC vnc, ServerStatus status, Date started, String user, @Nullable ServerMetrics metrics) {
        super(uuid, name, cpu, smp, mem, persistent, devices, bootDeviceIds, tags, userMetadata, nics, vnc);
        this.status = status;
        this.started = started;
        this.user = user;
        this.metrics = metrics;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public Date getStarted() {
        return this.started;
    }

    @Nullable
    public ServerMetrics getMetrics() {
        return this.metrics;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = 31 * result + (this.started == null ? 0 : this.started.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerInfo other = (ServerInfo)obj;
        if (this.metrics == null ? other.metrics != null : !this.metrics.equals(other.metrics)) {
            return false;
        }
        if (this.started == null ? other.started != null : !this.started.equals(other.started)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @Override
    public String toString() {
        return "[cpu=" + this.cpu + ", smp=" + this.smp + ", mem=" + this.mem + ", persistent=" + this.persistent + ", devices=" + this.devices + ", bootDeviceIds=" + this.bootDeviceIds + ", nics=" + this.nics + ", vnc=" + this.vnc + ", uuid=" + this.uuid + ", name=" + this.name + ", tags=" + this.tags + ", userMetadata=" + this.userMetadata + ", status=" + (Object)((Object)this.status) + ", started=" + this.started + ", user=" + this.user + ", metrics=" + this.metrics + "]";
    }

    public static class Builder
    extends Server.Builder {
        protected ServerStatus status;
        protected Date started;
        protected String user;
        protected ServerMetrics metrics;

        public Builder status(ServerStatus status) {
            this.status = status;
            return this;
        }

        public Builder started(Date started) {
            this.started = started;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder metrics(ServerMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        @Override
        public Builder cpu(int cpu) {
            return (Builder)Builder.class.cast(super.cpu(cpu));
        }

        @Override
        public Builder smp(Integer smp) {
            return (Builder)Builder.class.cast(super.smp(smp));
        }

        @Override
        public Builder mem(int mem) {
            return (Builder)Builder.class.cast(super.mem(mem));
        }

        @Override
        public Builder persistent(boolean persistent) {
            return (Builder)Builder.class.cast(super.persistent(persistent));
        }

        @Override
        public Builder devices(Map<String, ? extends Device> devices) {
            return (Builder)Builder.class.cast(super.devices(devices));
        }

        @Override
        public Builder bootDeviceIds(Iterable<String> bootDeviceIds) {
            return (Builder)Builder.class.cast(super.bootDeviceIds(bootDeviceIds));
        }

        @Override
        public Builder nics(Iterable<NIC> nics) {
            return (Builder)Builder.class.cast(super.nics(nics));
        }

        @Override
        public Builder vnc(VNC vnc) {
            return (Builder)Builder.class.cast(super.vnc(vnc));
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags((Iterable)tags));
        }

        @Override
        public Builder userMetadata(Map<String, String> userMetadata) {
            return (Builder)Builder.class.cast(super.userMetadata((Map)userMetadata));
        }

        @Override
        public ServerInfo build() {
            return new ServerInfo(this.uuid, this.name, this.cpu, this.smp, this.mem, this.persistent, this.devices, this.bootDeviceIds, this.tags, this.userMetadata, this.nics, this.vnc, this.status, this.started, this.user, this.metrics);
        }
    }
}

