/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.xml.AllocateAddressResponseHandler;
import org.jclouds.ec2.xml.DescribeAddressesResponseHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface ElasticIPAddressAsyncClient {
    @POST
    @Path(value="/")
    @XMLResponseParser(value=AllocateAddressResponseHandler.class)
    @FormParams(keys={"Action"}, values={"AllocateAddress"})
    public ListenableFuture<String> allocateAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AssociateAddress"})
    public ListenableFuture<Void> associateAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="PublicIp") String var2, @FormParam(value="InstanceId") String var3);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DisassociateAddress"})
    public ListenableFuture<Void> disassociateAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="PublicIp") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ReleaseAddress"})
    public ListenableFuture<Void> releaseAddressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="PublicIp") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeAddresses"})
    @XMLResponseParser(value=DescribeAddressesResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<PublicIpInstanceIdPair>> describeAddressesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

