/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.inject.Singleton;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.util.Predicates2;

@Singleton
public class EncodedRSAPublicKeyToBase64
implements Function<Object, String> {
    private static final Predicate<String> ALLOWED_MARKERS = Predicates.or(Predicates2.startsWith("ssh-rsa"), Predicates2.startsWith("-----BEGIN CERTIFICATE-----"), Predicates2.startsWith("---- BEGIN SSH2 PUBLIC KEY ----"));

    @Override
    public String apply(Object from) {
        Preconditions.checkNotNull(from, "input");
        String fromString = from.toString();
        Preconditions.checkArgument(ALLOWED_MARKERS.apply(fromString), "must be a ssh public key, conforming to %s ", ALLOWED_MARKERS);
        return CryptoStreams.base64(fromString.getBytes(Charsets.UTF_8));
    }
}

