/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;

public class Processor
implements Comparable<Processor> {
    private final double cores;
    private final double speed;

    public Processor(double cores, double speed) {
        this.cores = cores;
        this.speed = speed;
    }

    @Override
    public int compareTo(Processor that) {
        if (that instanceof Processor) {
            Processor thatProcessor = (Processor)Processor.class.cast(that);
            return ComparisonChain.start().compare(this.getCores(), thatProcessor.getCores()).compare(this.getSpeed(), thatProcessor.getSpeed()).result();
        }
        return -1;
    }

    public double getCores() {
        return this.cores;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Processor that = (Processor)Processor.class.cast(o);
        return Objects.equal(this.cores, that.cores) && Objects.equal(this.speed, that.speed);
    }

    public int hashCode() {
        return Objects.hashCode(this.cores, this.speed);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper("").omitNullValues().add("cores", this.cores).add("speed", this.speed);
    }
}

