/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListAccountsOptions
extends AccountInDomainOptions {
    public static final ListAccountsOptions NONE = new ListAccountsOptions();

    public ListAccountsOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListAccountsOptions name(String name) {
        this.queryParameters.replaceValues("name", ImmutableSet.of(name));
        return this;
    }

    public ListAccountsOptions state(String state) {
        this.queryParameters.replaceValues("state", ImmutableSet.of(state));
        return this;
    }

    public ListAccountsOptions cleanupRequired(boolean cleanupRequired) {
        this.queryParameters.replaceValues("iscleanuprequired", ImmutableSet.of(cleanupRequired + ""));
        return this;
    }

    public ListAccountsOptions recursive(boolean recursive) {
        this.queryParameters.replaceValues("isrecursive", ImmutableSet.of(recursive + ""));
        return this;
    }

    @Override
    public ListAccountsOptions accountInDomain(String account, String domain) {
        return (ListAccountsOptions)ListAccountsOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListAccountsOptions domainId(String domainId) {
        return (ListAccountsOptions)ListAccountsOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListAccountsOptions accountInDomain(String account, String domain) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListAccountsOptions domainId(String id) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.domainId(id);
        }

        public static ListAccountsOptions id(String id) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.id(id);
        }

        public static ListAccountsOptions name(String name) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.name(name);
        }

        public static ListAccountsOptions state(String state) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.state(state);
        }

        public static ListAccountsOptions cleanupRequired(boolean cleanupRequired) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.cleanupRequired(cleanupRequired);
        }

        public static ListAccountsOptions recursive(boolean recursive) {
            ListAccountsOptions options = new ListAccountsOptions();
            return options.recursive(recursive);
        }
    }
}

