/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.filters;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.utils.Queries;

public class ReEncodeQueryWithDefaultURLEncoder
implements HttpRequestFilter {
    private final Provider<UriBuilder> builders;

    @Inject
    public ReEncodeQueryWithDefaultURLEncoder(Provider<UriBuilder> builders) {
        this.builders = builders;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        UriBuilder builder = this.builders.get();
        builder.uri(request.getEndpoint());
        Multimap<String, String> map = Queries.parseQueryToMap(request.getEndpoint().getRawQuery());
        builder.replaceQuery("");
        for (String key : map.keySet()) {
            builder.queryParam(key, Iterables.getOnlyElement(map.get(key)));
        }
        return ((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(builder.build(new Object[0]))).build();
    }
}

