/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.functions.SplitNewlines;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class SplitNewlinesAndReturnSecondField
extends SplitNewlines {
    @Inject
    SplitNewlinesAndReturnSecondField(ReturnStringIf2xx returnStringIf200) {
        super(returnStringIf200);
    }

    @Override
    public Set<String> apply(HttpResponse response) {
        return ImmutableSet.copyOf(Iterables.filter(Iterables.transform(super.apply(response), new Function<String, String>(){

            @Override
            public String apply(String arg0) {
                if (arg0 == null) {
                    return null;
                }
                Iterable<String> parts = Splitter.on(' ').split(arg0);
                if (Iterables.size(parts) == 2) {
                    return Iterables.get(parts, 1);
                }
                if (Iterables.size(parts) == 1) {
                    return Iterables.get(parts, 0);
                }
                return null;
            }
        }), Predicates.notNull()));
    }
}

