/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.domain;

import com.google.common.base.Preconditions;
import org.jclouds.cloudsigma.domain.ProfileType;

public class ProfileInfo {
    protected final String uuid;
    protected final String email;
    protected final String firstName;
    protected final String lastName;
    protected final String nickName;
    protected final ProfileType type;

    public ProfileInfo(String uuid, String email, String firstName, String lastName, String nickName, ProfileType type) {
        this.uuid = Preconditions.checkNotNull(uuid, "uuid");
        this.email = Preconditions.checkNotNull(email, "email");
        this.firstName = Preconditions.checkNotNull(firstName, "firstName");
        this.lastName = Preconditions.checkNotNull(lastName, "lastName");
        this.nickName = Preconditions.checkNotNull(nickName, "nickName");
        this.type = Preconditions.checkNotNull(type, "type");
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getEmail() {
        return this.email;
    }

    protected String getFirstName() {
        return this.firstName;
    }

    protected String getLastName() {
        return this.lastName;
    }

    protected String getNickName() {
        return this.nickName;
    }

    protected ProfileType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.nickName == null ? 0 : this.nickName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileInfo other = (ProfileInfo)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.nickName == null ? other.nickName != null : !this.nickName.equals(other.nickName)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return "[uuid=" + this.uuid + ", email=" + this.email + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", nickName=" + this.nickName + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static class Builder {
        protected String uuid;
        protected String email;
        protected String firstName;
        protected String lastName;
        protected String nickName;
        protected ProfileType type = ProfileType.REGULAR;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public Builder type(ProfileType type) {
            this.type = type;
            return this;
        }

        public ProfileInfo build() {
            return new ProfileInfo(this.uuid, this.email, this.firstName, this.lastName, this.nickName, this.type);
        }
    }
}

