/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain;

import org.jclouds.cloudloadbalancers.domain.internal.BaseNode;

public class NodeAttributes {
    protected String condition;
    protected Integer weight;

    public NodeAttributes condition(String condition) {
        this.condition = condition;
        return this;
    }

    public NodeAttributes weight(int weight) {
        this.weight = weight;
        return this;
    }

    public static <T extends BaseNode<T>> NodeAttributes fromNode(T n) {
        return Builder.condition(n.getCondition()).weight(n.getWeight());
    }

    public String toString() {
        return String.format("[condition=%s, weight=%s]", this.condition, this.weight);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeAttributes other = (NodeAttributes)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
    }

    public static class Builder {
        public static NodeAttributes condition(BaseNode.Condition condition) {
            return new NodeAttributes().condition(condition.name());
        }

        public static NodeAttributes weight(int weight) {
            return new NodeAttributes().weight(weight);
        }
    }
}

