/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudloadbalancers.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import org.jclouds.cloudloadbalancers.domain.Node;
import org.jclouds.cloudloadbalancers.domain.VirtualIP;
import org.jclouds.cloudloadbalancers.domain.internal.BaseLoadBalancer;
import org.jclouds.javax.annotation.Nullable;

public class LoadBalancer
extends BaseLoadBalancer<Node, LoadBalancer> {
    public static Algorithm[] WEIGHTED_ALGORITHMS = new Algorithm[]{Algorithm.WEIGHTED_LEAST_CONNECTIONS, Algorithm.WEIGHTED_ROUND_ROBIN};
    private final String region;
    private final int id;
    private final Status status;
    private final Algorithm algorithm;
    private final Set<VirtualIP> virtualIPs;
    private final String sessionPersistenceType;
    private final String clusterName;
    private final Date created;
    private final Date updated;
    private final boolean connectionLoggingEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public LoadBalancer(String region, int id, String name, String protocol, Integer port, @Nullable String algorithm, Status status, Iterable<VirtualIP> virtualIPs, Iterable<Node> nodes, String sessionPersistenceType, String clusterName, Date created, Date updated, boolean connectionLoggingEnabled) {
        super(name, protocol, port, algorithm, nodes);
        this.region = Preconditions.checkNotNull(region, "region");
        Preconditions.checkArgument(id != -1, "id must be specified");
        this.id = id;
        this.status = Preconditions.checkNotNull(status, "status");
        this.algorithm = algorithm != null ? Algorithm.fromValue(algorithm) : null;
        this.virtualIPs = ImmutableSet.copyOf(Preconditions.checkNotNull(virtualIPs, "virtualIPs"));
        this.sessionPersistenceType = sessionPersistenceType;
        this.clusterName = clusterName;
        this.created = Preconditions.checkNotNull(created, "created");
        this.updated = Preconditions.checkNotNull(updated, "updated");
        this.connectionLoggingEnabled = connectionLoggingEnabled;
    }

    public String getRegion() {
        return this.region;
    }

    public int getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    @Nullable
    public Algorithm getTypedAlgorithm() {
        return this.algorithm;
    }

    public Set<VirtualIP> getVirtualIPs() {
        return this.virtualIPs;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getSessionPersistenceType() {
        return this.sessionPersistenceType;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public boolean isConnectionLoggingEnabled() {
        return this.connectionLoggingEnabled;
    }

    @Override
    public String toString() {
        return String.format("[region=%s, id=%s, name=%s, protocol=%s, port=%s, algorithm=%s, status=%s, virtualIPs=%s, nodes=%s, sessionPersistenceType=%s, created=%s, updated=%s, clusterName=%s, connectionLoggingEnabled=%s]", new Object[]{this.region, this.id, this.name, this.protocol, this.port, this.algorithm, this.status, this.virtualIPs, this.nodes, this.sessionPersistenceType, this.created, this.updated, this.clusterName, this.connectionLoggingEnabled});
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.id;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }

    public static enum Algorithm {
        LEAST_CONNECTIONS,
        RANDOM,
        ROUND_ROBIN,
        WEIGHTED_LEAST_CONNECTIONS,
        WEIGHTED_ROUND_ROBIN,
        UNRECOGNIZED;


        public static Algorithm fromValue(String algorithm) {
            try {
                return Algorithm.valueOf(Preconditions.checkNotNull(algorithm, "algorithm"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Status {
        BUILD,
        ACTIVE,
        PENDING_UPDATE,
        SUSPENDED,
        PENDING_DELETE,
        DELETED,
        ERROR,
        UNRECOGNIZED;


        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "status"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder
    extends BaseLoadBalancer.Builder<Node, LoadBalancer> {
        private String region;
        private int id = -1;
        private Status status;
        private Set<VirtualIP> virtualIPs = ImmutableSet.of();
        private String sessionPersistenceType;
        private String clusterName;
        private Date created;
        private Date updated;
        private boolean connectionLoggingEnabled;

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm(algorithm.name());
            return this;
        }

        public Builder virtualIPs(Iterable<VirtualIP> virtualIPs) {
            this.virtualIPs = ImmutableSet.copyOf(Preconditions.checkNotNull(virtualIPs, "virtualIPs"));
            return this;
        }

        public Builder sessionPersistenceType(String sessionPersistenceType) {
            this.sessionPersistenceType = sessionPersistenceType;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public Builder connectionLoggingEnabled(boolean connectionLoggingEnabled) {
            this.connectionLoggingEnabled = connectionLoggingEnabled;
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.region, this.id, this.name, this.protocol, this.port, this.algorithm, this.status, this.virtualIPs, this.nodes, this.sessionPersistenceType, this.clusterName, this.created, this.updated, this.connectionLoggingEnabled);
        }

        public Builder nodes(Iterable<Node> nodes) {
            this.nodes = ImmutableSet.copyOf(Preconditions.checkNotNull(nodes, "nodes"));
            return this;
        }

        public Builder node(Node nodes) {
            this.nodes.add(Preconditions.checkNotNull(nodes, "nodes"));
            return this;
        }

        public Builder algorithm(String algorithm) {
            return (Builder)Builder.class.cast(super.algorithm(algorithm));
        }

        public Builder from(LoadBalancer in) {
            return ((Builder)Builder.class.cast(super.from(in))).id(in.getId()).status(in.getStatus()).virtualIPs(in.getVirtualIPs()).clusterName(in.getClusterName()).created(in.getCreated()).updated(in.getUpdated()).connectionLoggingEnabled(in.isConnectionLoggingEnabled());
        }

        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        public Builder port(Integer port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder protocol(String protocol) {
            return (Builder)Builder.class.cast(super.protocol(protocol));
        }
    }
}

