/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cache.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingObject;
import java.util.concurrent.Callable;
import org.jclouds.util.Throwables2;

@Beta
class BackoffExponentiallyAndRetryOnThrowableCallable<T>
extends ForwardingObject
implements Callable<T> {
    private final Class<? extends Throwable> retryableThrowable;
    private final long periodMs;
    private final long maxPeriodMs;
    private final int maxTries;
    private final Callable<T> callable;

    BackoffExponentiallyAndRetryOnThrowableCallable(Class<? extends Throwable> retryableThrowable, long periodMs, long maxPeriodMs, int maxTries, Callable<T> callable) {
        this.retryableThrowable = Preconditions.checkNotNull(retryableThrowable, "retryableThrowable");
        Preconditions.checkArgument(maxTries > 1, "maxTries must be more than one: %d", maxTries);
        this.maxTries = maxTries;
        Preconditions.checkArgument(periodMs > 0L, "periodMs must be positive: %d", periodMs);
        this.periodMs = periodMs;
        Preconditions.checkArgument(maxPeriodMs > periodMs, "maxPeriodMs must be equal to or greater than periodMs: %d %d", maxPeriodMs, periodMs);
        this.maxPeriodMs = maxPeriodMs;
        this.callable = Preconditions.checkNotNull(callable, "callable");
    }

    @Override
    protected Callable<T> delegate() {
        return this.callable;
    }

    @Override
    public T call() throws Exception {
        Exception currentException = null;
        for (int currentTries = 0; currentTries < this.maxTries; ++currentTries) {
            try {
                return (T)this.delegate().call();
            }
            catch (Exception e) {
                currentException = e;
                if (Throwables2.getFirstThrowableOfType(e, this.retryableThrowable) == null) {
                    throw e;
                }
                this.imposeBackoffExponentialDelay(this.periodMs, this.maxPeriodMs, 2, currentTries, this.maxTries);
                continue;
            }
        }
        throw currentException;
    }

    void imposeBackoffExponentialDelay(long period, long maxPeriod, int pow, int failureCount, int max) {
        long delayMs = (long)((double)period * Math.pow(failureCount, pow));
        delayMs = delayMs > maxPeriod ? maxPeriod : delayMs;
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            Throwables.propagate(e);
        }
    }

    @Override
    public String toString() {
        return Objects.toStringHelper("").add("retryableThrowable", this.retryableThrowable).add("periodMs", this.periodMs).add("maxPeriodMs", this.maxPeriodMs).add("maxTries", this.maxTries).add("callable", this.callable).toString();
    }
}

