/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.reference.BlobStoreConstants;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;

@Singleton
public class MarkersIfDirectoryReturnNameStrategy
implements IfDirectoryReturnNameStrategy {
    @Override
    public String execute(StorageMetadata metadata) {
        switch (metadata.getType()) {
            case CONTAINER: 
            case FOLDER: 
            case RELATIVE_PATH: {
                return metadata.getName();
            }
            case BLOB: {
                BlobMetadata blobMd = (BlobMetadata)metadata;
                for (String suffix : BlobStoreConstants.DIRECTORY_SUFFIXES) {
                    if (!metadata.getName().endsWith(suffix)) continue;
                    return metadata.getName().substring(0, metadata.getName().lastIndexOf(suffix));
                }
                if (blobMd.getContentMetadata().getContentType() == null || !blobMd.getContentMetadata().getContentType().equals("application/directory")) break;
                return metadata.getName();
            }
        }
        return null;
    }
}

