/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.s3.blobstore.AWSS3AsyncBlobStore;
import org.jclouds.aws.s3.blobstore.AWSS3BlobStore;
import org.jclouds.aws.s3.blobstore.strategy.AsyncMultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.internal.ParallelMultipartUploadStrategy;
import org.jclouds.aws.s3.blobstore.strategy.internal.SequentialMultipartUploadStrategy;
import org.jclouds.cache.RetryingCacheLoaderDecorator;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.S3AsyncBlobStore;
import org.jclouds.s3.blobstore.S3BlobStore;
import org.jclouds.s3.blobstore.config.S3BlobStoreContextModule;
import org.jclouds.s3.domain.AccessControlList;

public class AWSS3BlobStoreContextModule
extends S3BlobStoreContextModule {
    @Override
    protected void configure() {
        super.configure();
        this.bind(S3AsyncBlobStore.class).to(AWSS3AsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(S3BlobStore.class).to(AWSS3BlobStore.class).in(Scopes.SINGLETON);
        this.bind(MultipartUploadStrategy.class).to(SequentialMultipartUploadStrategy.class);
        this.bind(AsyncMultipartUploadStrategy.class).to(ParallelMultipartUploadStrategy.class);
    }

    @Override
    protected LoadingCache<String, AccessControlList> bucketAcls(final S3Client client) {
        CacheLoader<String, AccessControlList> loader = RetryingCacheLoaderDecorator.newDecorator().on(ResourceNotFoundException.class).exponentiallyBackoff().decorate(new CacheLoader<String, AccessControlList>(){

            @Override
            public AccessControlList load(String bucketName) {
                return client.getBucketACL(bucketName);
            }

            public String toString() {
                return "getBucketAcl()";
            }
        });
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(loader);
    }
}

