/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.util;

import com.google.common.base.Supplier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.domain.AtmosError;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.atmos.xml.ErrorHandler;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.crypto.Crypto;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.Assertions;

public class AtmosUtils {
    @Inject
    SignRequest signer;
    @Inject
    ParseSax.Factory factory;
    @Inject
    Provider<ErrorHandler> errorHandlerProvider;

    public AtmosError parseAtmosErrorFromContent(HttpCommand command, HttpResponse response, InputStream content) throws HttpException {
        AtmosError error = (AtmosError)this.factory.create(this.errorHandlerProvider.get()).parse(content);
        if (error.getCode() == 1032) {
            error.setStringSigned(this.signer.createStringToSign(command.getCurrentRequest()));
        }
        return error;
    }

    public static String putBlob(AtmosClient sync, Crypto crypto, BlobToObject blob2Object, String container, Blob blob, PutOptions options) {
        String path = container + "/" + blob.getMetadata().getName();
        AtmosObject object = blob2Object.apply(blob);
        try {
            sync.createFile(container, object, options);
        }
        catch (KeyAlreadyExistsException e) {
            AtmosUtils.deleteAndEnsureGone(sync, path);
            sync.createFile(container, object, options);
        }
        return path;
    }

    public static void deleteAndEnsureGone(final AtmosClient sync, final String path) {
        try {
            if (!Assertions.eventuallyTrue(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    sync.deletePath(path);
                    return !sync.pathExists(path);
                }
            }, 3000L)) {
                throw new IllegalStateException(path + " still exists after deleting!");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(path + " interrupted during deletion!", e);
        }
    }

    public AtmosError parseAtmosErrorFromContent(HttpCommand command, HttpResponse response, String content) throws HttpException {
        return this.parseAtmosErrorFromContent(command, response, new ByteArrayInputStream(content.getBytes()));
    }

    public static String adjustContainerIfDirOptionPresent(String container, ListContainerOptions options) {
        if (options != ListContainerOptions.NONE && options.getDir() != null) {
            container = container + "/" + options.getDir();
        }
        return container;
    }
}

