/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeaders;
import org.jclouds.atmos.functions.ParseUserMetadataFromHeaders;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectFromHeadersAndHttpContent
implements Function<HttpResponse, AtmosObject>,
InvocationContext<ParseObjectFromHeadersAndHttpContent> {
    private final ParseSystemMetadataFromHeaders systemMetadataParser;
    private final ParseUserMetadataFromHeaders userMetadataParser;
    private final AtmosObject.Factory objectProvider;
    private URI uri;
    private String path;

    @Inject
    public ParseObjectFromHeadersAndHttpContent(ParseSystemMetadataFromHeaders systemMetadataParser, ParseUserMetadataFromHeaders userMetadataParser, AtmosObject.Factory objectProvider) {
        this.systemMetadataParser = Preconditions.checkNotNull(systemMetadataParser, "systemMetadataParser");
        this.userMetadataParser = Preconditions.checkNotNull(userMetadataParser, "userMetadataParser");
        this.objectProvider = Preconditions.checkNotNull(objectProvider, "objectProvider");
    }

    @Override
    public AtmosObject apply(HttpResponse from) {
        Preconditions.checkNotNull(from, "http response");
        AtmosObject object = this.objectProvider.create(this.systemMetadataParser.apply(from), this.userMetadataParser.apply(from));
        object.getContentMetadata().setName(object.getSystemMetadata().getObjectName());
        object.getContentMetadata().setPath(this.path);
        object.getContentMetadata().setUri(this.uri);
        object.getAllHeaders().putAll(from.getHeaders());
        object.setPayload(from.getPayload());
        object.getContentMetadata().setContentLength(HttpUtils.attemptToParseSizeAndRangeFromHeaders(from));
        return object;
    }

    @Override
    public ParseObjectFromHeadersAndHttpContent setContext(HttpRequest request) {
        this.uri = request.getEndpoint();
        return this.setPath(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getArgs().get(0).toString());
    }

    private ParseObjectFromHeadersAndHttpContent setPath(String path) {
        this.path = path;
        return this;
    }
}

