/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class SignRequest
implements HttpRequestFilter {
    private final SignatureWire signatureWire;
    private final String uid;
    private final byte[] key;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SignRequest(SignatureWire signatureWire, @Identity String uid, @Credential String encodedKey, @TimeStamp Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.uid = uid;
        this.key = CryptoStreams.base64(encodedKey);
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("x-emc-uid", this.uid);
        String date = this.timeStampProvider.get();
        builder.put("Date", date);
        if (request.getHeaders().containsKey("x-emc-date")) {
            builder.put("x-emc-date", date);
        }
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(builder.build()))).build();
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-emc-signature", signature)).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendCanonicalizedResource(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(buffer.toString());
        }
        return buffer.toString();
    }

    private String calculateSignature(String toSign) {
        String signature = this.signString(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream(signature));
        }
        return signature;
    }

    public String signString(String toSign) {
        String signature;
        try {
            signature = CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(toSign), this.crypto.hmacSHA1(this.key)));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
        return signature;
    }

    private void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    private void appendCanonicalizedHeaders(HttpRequest request, StringBuilder toSign) {
        TreeSet<String> headers = new TreeSet<String>(request.getHeaders().keySet());
        for (String header : headers) {
            if (!header.startsWith("x-emc-") || header.equals("x-emc-signature")) continue;
            toSign.append(header.toLowerCase()).append(":");
            for (String value : request.getHeaders().get(header)) {
                value = Strings2.replaceAll(value, Patterns.TWO_SPACE_PATTERN, " ");
                value = Strings2.replaceAll(value, Patterns.NEWLINE_PATTERN, "");
                toSign.append(value).append(' ');
            }
            toSign.deleteCharAt(toSign.lastIndexOf(" "));
            toSign.append("\n");
        }
        if (toSign.charAt(toSign.length() - 1) == '\n') {
            toSign.deleteCharAt(toSign.length() - 1);
        }
    }

    private void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    @VisibleForTesting
    void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        for (String header : new String[]{"Range"}) {
            toSign.append(HttpUtils.nullToEmpty(request.getHeaders().get(header)).toLowerCase()).append("\n");
        }
        toSign.append(request.getFirstHeaderOrNull("Date")).append("\n");
    }

    @VisibleForTesting
    void appendCanonicalizedResource(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath().toLowerCase()).append("\n");
    }
}

