/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.core.ComputeProviderOrApiRegistry;
import org.jclouds.providers.ProviderMetadata;

@Command(name="cloud-service-list", scope="fabric", description="Lists the cloud providers registered with the fabric.")
public class CloudServiceList
extends FabricCommand {
    public static final String PROVIDERFORMAT = "%-24s %-12s %-24s %-24s";
    private ComputeProviderOrApiRegistry computeProviderOrApiRegistry;
    private List<ComputeService> computeServices;

    protected Object doExecute() throws Exception {
        Map<String, ProviderMetadata> providers = this.computeProviderOrApiRegistry.getInstalledProviders();
        Map<String, ApiMetadata> apis = this.computeProviderOrApiRegistry.getInstalledApis();
        boolean providerOrApiFound = false;
        if (apis != null && !apis.isEmpty()) {
            providerOrApiFound = true;
            System.out.println("Compute APIs:");
            System.out.println("-------------");
            this.printComputeProvidersOrApis(apis.keySet(), this.computeServices, "", System.out);
        }
        if (providers != null && !providers.isEmpty()) {
            providerOrApiFound = true;
            System.out.println("Compute Providers:");
            System.out.println("-------------");
            this.printComputeProvidersOrApis(providers.keySet(), this.computeServices, "", System.out);
        }
        if (!providerOrApiFound) {
            System.out.println("No providers or apis have been found.");
        }
        return null;
    }

    protected void printComputeProvidersOrApis(Set<String> providersOrApis, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[local services]", "[fabric services]"));
        for (String providerOrApi : providersOrApis) {
            boolean registered = false;
            StringBuffer localServices = new StringBuffer();
            StringBuffer fabricServices = new StringBuffer();
            localServices.append("[ ");
            fabricServices.append("[ ");
            for (ComputeService computeService : computeServices) {
                if (!computeService.getContext().unwrap().getId().equals(providerOrApi)) continue;
                String name = computeService.getContext().unwrap().getName();
                if (this.getZooKeeper() != null && this.getZooKeeper().isConnected()) {
                    fabricServices.append(name).append(" ");
                    continue;
                }
                localServices.append(name).append(" ");
            }
            localServices.append("]");
            fabricServices.append("]");
            out.println(String.format(PROVIDERFORMAT, providerOrApi, "compute", localServices.toString(), fabricServices.toString()));
        }
    }

    public ComputeProviderOrApiRegistry getComputeProviderOrApiRegistry() {
        return this.computeProviderOrApiRegistry;
    }

    public void setComputeProviderOrApiRegistry(ComputeProviderOrApiRegistry computeProviderOrApiRegistry) {
        this.computeProviderOrApiRegistry = computeProviderOrApiRegistry;
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }
}

